'\"
'\" $Id: DirTree.n,v 1.1.1.1 2000/05/17 11:08:49 idiscovery Exp $
'\"
'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'----------------------------------------------------------------------
.HS tixDirTree tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixDirTree \- Create and manipulate tixDirTree widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixDirTree\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBTixDirTree\fR class is derived from the \fBTixScrolledHList\fR
class and inherits all the commands, options and subwidgets of its
super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
\fBTixDirTree\fR supports all the standard options of a frame widget.
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
Name:		\fBbrowseCmd\fR
Class:		\fBBrowseCmd\fR
Switch:		\fB\-browsecmd\fR
.fi
.IP
Specifies a command to call whenever the user browses on a directory
(usually by single-clicking on the name of the directory). The command
is called with one argument, the complete pathname of the directory.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the user activates on a directory
(usually by double-clicking on the name of the directory). The command
is called with one argument, the complete pathname of the directory.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdircmd\fR
Class:		\fBDirCmd\fR
Switch:		\fB\-dircmd\fR
.fi
.IP
Specifies the TCL command to be called when a directory listing is
needed for a particular directory. If this option is not specified, by
default the DirTree widget will attempt to read the directory as a
Unix directory. On special occasions, the application programmer may
want to supply a special method for reading directories: for example,
when he needs to list remote directories. In this case, the
\fB\-dircmd\fR option can be used. The specified command accepts two
arguments: the first is the name of the directory to be listed; the
second is a Boolean value indicating whether hidden sub-directories
should be listed. This command returns a list of names of the
sub-directories of this directory. For example:
\fC
.nf

 proc read_dir {dir show_hidden} {
     if {$dir == "C:\\"} {
         return {DOS NORTON WINDOWS}
     } else {
         return {}
     }
 }
.fi
\fR
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdisableCallback\fR
Class:		\fBDisableCallback\fR
Switch:		\fB\-disablecallback\fR
.fi
.IP
A boolean value indicating whether callbacks should be disabled. When
set to true, the TCL command specified by the \fB\-command\fR option
is not executed when the \fB\-value\fR of the DirTree widget
changes.
'----------END
'
'----------BEGIN
'
.LP
.nf
Name:		\fBshowHidden\fR
Class:		\fBShowHidden\fR
Switch:		\fB\-showhidden\fR
.fi
.IP
Specifies whether hidden directories should be shown. By default, a
directory name starting with a period "." is considered as a hidden
directory. This rule can be overridden by supplying an alternative
\fB\-dircmd\fR option.
'----------END
'
'----------END
'
.LP
.nf
Name:		\fBvalue\fR
Class:		\fBValue\fR
Switch:		\fB\-value\fR
Alias:		\fB\-directory\fR
.fi
.IP
Specifies the name of the current directory to be displayed in the
DirTree widget.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBhlist\fR
Class:		\fBTixHList\fR
.fi
.IP
The hierarchical listbox that displays the directory listing.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBhsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The horizontal scrollbar subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBvsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The vertical scrollbar subwidget.
'----------END
'
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixDirTree\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a DirTree widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
DirTree such as its cursor and relief.

The DirTree widget displays a list view of a directory, its
previous directories and its sub-directories. The user can choose one
of the directories displayed in the list or change to another
directory.
'
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixDirTree\fR command creates a new Tcl command whose name is
the same as the path name of the DirTree's window.  This
command may be used to invoke various operations on the widget. It has
the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
DirTree widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following commands
are possible for DirTree widgets:
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixDirTree\fR command.
'
.TP
\fIpathName \fBchdir\fR \fIdir\fR
'
Change the current directory to \fIdir\fR.
'
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list). If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixDirTree\fR command.
'
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'
'----------------------------------------------------------------------
.SH BINDINGS
.PP
'
The mouse and keyboard bindings of the DirTree widget are the same as
the bindings of the HList widget.
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
