'\"
'\" $Id: PanedWin.n,v 1.1.1.1 2000/05/17 11:08:50 idiscovery Exp $
'\"
'\"
'\" Copyright (c) 1996, Expert Interface Technologies
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The file man.macros and some of the macros used by this file are
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
.so man.macros
'----------------------------------------------------------------------
.HS tixPanedWindow tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixPanedWindow \- Create and manipulate tixPanedWindow widgets
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPanedWindow\fI \fIpathName ?\fIoptions\fR?
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The PanedWindow widget supports all the standard options of a frame
widget. See the \fBoptions(n)\fR manual entry for details on the
standard options.
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'----------BEGIN
.LP
.nf
'
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
'
.fi
.IP
'
Specifies the command to invoke when the panes change their sizes.
This command is called with a list of integers that record the new
sizes of the panes. The sizes of the panes are listed in the order of
the panes' creation.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBdynamicGeometry\fR
Class:		\fBDynamicGeometry\fR
Switch:		\fB\-dynamicgeometry\fR
.fi
.IP
'
If set to true, the size of the PanedWindow will dynamically change
if the size of any of its panes changes. Otherwise, the size of the
PanedWindow will only increase when size of any of its panes changes
and will not decrease. The default value is true.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleActiveBg\fR
Class:		\fBHandleActiveBg\fR
Switch:		\fB\-handleactivebg\fR
'
.fi
.IP
'
Specifies the active background color of the resize handles. When the
mouse cursor enters a resize handle, the resize handle will adopt
the active background color.
'----------END
'
'
'----------BEGIN
.LP
.nf
'
Name:		\fBhandleBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-handlebg\fR
'
.fi
.IP
'
Specifies the normal background color of the resize handles.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBorientation\fR
Class:		\fBOrientation\fR
Switch:		\fB\-orientation\fR
Alias:		\fB\-orient\fR
.fi
.IP
Specifies the orientation of the panes. Must be either \fBvertical\fR
or \fBhorizontal\fR.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneBorderWidth\fR
Class:		\fBPaneBorderWidth\fR
Switch:		\fB\-paneborderwidth\fR
Alias:		\fB\-panebd\fR
.fi
.IP
Specifies the border width of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBpaneRelief\fR
Class:		\fBPaneRelief\fR
Switch:		\fB\-panerelief\fR
.fi
.IP
Specifies the border relief of the panes.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorActiveBg\fR
Class:		\fBSeparatorActiveBg\fR
Switch:		\fB\-separatoractivebg\fR
'
.fi
.IP
'
Specifies the active background color of the separators. When the user
grabs a resize handle, the separators
will adopt the active background color.
'----------END
'
'----------BEGIN
.LP
.nf
'
Name:		\fBseparatorBg\fR
Class:		\fBBackground\fR
Switch:		\fB\-separatorbg\fR
'
.fi
.IP
'
Specifies the normal background color of the separators.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB\-width\fR
.fi
.IP
Specifies the desired width for the window.
'----------END
'----------------------------------------------------------------------
.SH SUBWIDGETS
.PP
'
All the pane subwidgets created as a result of the \fBadd\fR command
can be accessed by the \fBsubwidget\fR command. They are identified by
the \fBpaneName\fR parameter to the \fBadd\fR command.
'
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION

.PP
'
The \fBtixPanedWindow\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PanedWindow widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PanedWindow widget such as its cursor and relief.
'
.PP
'
The PanedWindow widget allows the user to interactively manipulate the
sizes of several panes. The panes can be arranged either vertically or
horizontally. Each individual pane may have upper and lower limits of
its size. The user changes the sizes of the panes by dragging the
resize handle between two panes.
'
'----------------------------------------------------------------------
.SH "WIDGET COMMAND"
'
.PP
'
The \fBtixPanedWindow\fR command creates a new Tcl command whose name is
the same as the path name of the PanedWindow widget's window.  This
command may be used to invoke various operations on the widget.  It
has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
'
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
frame widget's path name. \fIOption\fR and the \fIarg\fRs determine
the exact behavior of the command.  The following commands are
possible for PanedWindow widgets:
'
.TP 
'
\fIpathName \fBadd\fI paneName \fR?\fIoption value ...\fR?
'
Adds a new pane subwidget with the name \fIpaneName\fR into the
PanedWindow widget. Additional configuration options can be
given to configure the new button subwidget. Three configuration
options are supported:
.RS
'
.TP
\fB\-after\fR \fIpane\fR
'
Specifies that the new pane should be placed after \fIpane\fR in the
list of panes in this PanedWindow widget.
'
\fB\-at\fR \fIinteger\fR
'
Specifies the position of the new pane in the list of panes in this
PanedWindow widget. \fB0\fR means the first position, \fB1\fR means
the second, and so on. In addition, \fBend\fR means the end of the
list.
'
.TP
\fB\-before\fR \fIpane\fR
'
Specifies that the new pane should be placed before \fIpane\fR in the
list of panes in this PanedWindow widget.
'
.TP
\fB\-expand\fR \fIfactor\fR
'
Specifies the \fBexpand/shrink factor\fR of this pane. \fIFactor\fR
must be a non-negative floating point number. The default value is
0.0. The expand/shrink factor is used to calculate how much each pane
should grow or shrink when the size of the PanedWindow main window is
changed. When the main window expands/shrinks by \fIn\fR pixels, then
pane \fIi\fR will grow/shrink by about \fIn * factor(i) /
summation(factors)\fR, where \fIfactor(i)\fR is the expand/shrink
factor of pane i and \fIsummation(factors)\fR is the summation of the
expand/shrink factors of all the panes. If \fIsummation(factors)\fR is
0.0, however, only the last visible pane will be grown or shrunk.
'
.TP
\fB\-min\fR \fIinteger\fR
'
Specifies the minimum size, in pixels, of the new pane; the default is 0.
'
.TP
\fB\-max\fR \fIinteger\fR
Specifies the maximum size, in pixels, of the new pane; the default is 10000.
'
.TP
\fB\-size\fR \fIinteger\fR
Specifies the size, in pixels, of the new pane; if the \fB\-size\fR
option is not given, or set to the empty string, the PanedWindow
widget will use the natural size of the pane subwidget.
'
.RE
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may be \fB\-min\fR, \fB\-max\fR and/or
\fB\-size\fR, or any option accepted by the Tk frame widget.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string. \fIOption\fR may be any
of the non-static options of the PanedWindow widget.
'
.TP
\fIpathName \fBdelete\fR \fIpaneName\fR
'
Removes the pane given by \fIpaneName\fR and deletes its contents.
'
.TP
\fIpathName \fBforget\fR \fIpaneName\fR
'
Removes the pane given by \fIpaneName\fR but does not delete its
contents. This pane can be later added back to the PanedWindow widget
by the \fBmanage\fR method.
'
.TP
\fIpathName \fBmanage\fR \fIpaneName \fR?\fIoption value ...\fR?
'
Adds the pane given by \fIpaneName\fR back to the PanedWindow widget.
\fIPaneName\fR must be already forgotten by the \fBforget\fR
method. Additional \fIoption-value\fR pairs, same as those accepted by
the \fBadd\fR method, can be given to control the appearance and
position of the pane.
'
.TP
\fIpathName \fBpanecget\fR \fIpaneName option\fR
'
Returns the current value of the configuration option given by
\fIoption\fR in the pane given by \fIpaneName\fR. \fIOption\fR may
have any of the values accepted by the \fBadd\fR widget command.
'
.TP
'
\fIpathName \fBpaneconfigure\fI paneName ?\fIoption\fR? \fI?value ...\fR?
'
'
When no option is given, prints out the values of all options of this
pane. If \fIoption\fR is specified with no \fIvalue\fR, then the
command returns the current value of that option. If one or more
\fIoption\-value\fR pairs are specified, then the command modifies the
given pane's option(s) to have the given value(s); in this case the
command returns an empty string. \fIOption\fR may be \fB\-min\fR,
\fB\-max\fR and/or \fB\-size\fR, or any option accepted by the Tk
frame widget. The sizes of the panes may be changed as a result of
calling the \fBpaneconfigure\fR command.
'
.TP
\fIpathName \fBpanes\fR
'
Returns a list of the names of all panes.
'
.TP
\fIpathName \fBsetsize\fR \fIpaneName newSize\fR ?\fIdirection\fR?
'
Sets the size of the pane specified by \fIpaneName\fR to
\fInewSize\fR. The \fIdirection\fR parameter specifies in which
direction the pane should grow/shrink. Possible values are \fBnext\fR:
the pane will grow or shrink by moving the boundary between itself and
the pane to its right or bottom; \fBprev\fR: the pane will grow or
shrink by moving the boundary between itself and the pane to its left
or top.
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, returns the pathname of the subwidget of
the specified name.

When options are given, the widget command of the specified subwidget will
be called with these options.
'
'----------------------------------------------------------------------
.SH BINDINGS
'
The panes' sizes will be changed when the user drags the handles. The
change in the panes' sizes may be subjected to the \fB\-min\fR,
\fB\-max\fR and \fB\-size\fR options of the panes.
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
'
TIX, Container Widget
