.\"
.\" TclXInit.3
.\"
.\" Extended Tcl initialization functions.
.\"----------------------------------------------------------------------------
.\" Copyright 1992-1994 Karl Lehenbauer and Mark Diekhans.
.\"
.\" Permission to use, copy, modify, and distribute this software and its
.\" documentation for any purpose and without fee is hereby granted, provided
.\" that the above copyright notice appear in all copies.  Karl Lehenbauer and
.\" Mark Diekhans make no representations about the suitability of this
.\" software for any purpose.  It is provided "as is" without express or
.\" implied warranty.
.\"----------------------------------------------------------------------------
.\" $Id: TclXInit.3,v 2.0 1994/12/23 20:24:40 karl Exp $
.\"----------------------------------------------------------------------------
.\"
.TH "TclXInit" TCL "" "Tcl"
.ad b
.SH NAME
TclX_Init, TclXCmd_Init, TclXLib_Init, TclX_Shell - Extended Tcl initialization.
'
.SH SYNOPSIS
.nf
.ft CW

-ltclx -ltcl

#include "tclExtend.h"

extern char *tclAppName;
extern char *tclAppLongname;
extern char *tclAppVersion;
extern int   tclAppPatchlevel;

int
Tcl_AppInit (Tcl_Interp *interp);

int
TclX_Init (Tcl_Interp *interp);

int
TclXCmd_Init (Tcl_Interp *interp);

int
TclXLib_Init (Tcl_Interp *interp);

void
TclX_Shell (int    argc,
            char **argv);
.ft R
.fi
.SH DESCRIPTION
These functions are used to initialize Extended Tcl and applications based
on Extended Tcl.
.P
IMPORTANT NOTE:  \fBlibtclx.a\fR must be specified on the link command line
before \fBlibtcl.a\fR.  If the order is reversed, incorrect command line
parsing code will be used.
'
.SS tclAppName
The application name to be returned by the \fBinfox\fR
command. This should be a short mnemonic.  This value maybe altered from
the default by the application.
'
.SS tclAppLongname
The application long name to be returned by the \fBinfox\fR command.
This should be a natural language string.  This value maybe altered from
the default by the application.
'
.SS tclAppVersion
The application version string to be returned by the \fBinfox\fR command.
procedures are called.  This value maybe altered from
the default by the application.
'
.SS tclAppPatchlevel
The application patchlevel to be returned by the \fBinfox\fR command.
procedures are called.  This value maybe altered from
the default by the application.
'
.SS Tcl_AppInit
.PP
This function is used to initialize an TclX based application.
It is intended to
the the only file that is modified for most applications.
There are two versions of this function, one for applications built on
just TclX and the other for applications built on TclX and Tk.
.PP
The TclX version of this function is found in \fBtclXAppInit.c\fR and the 
Tk version is found in \fBtkXAppInit.c\fR.  It should be modified according to
the instructions in these files to initialize a TclX based application.
.PP
A custom application is then linked in a manner similar to:
.sp
.nf
.ft CW
  cc tclXAppInit.o mystuff.a libtclx.a libtcl.a ${SYSLIBS} -o myapp
.ft R
.fi
.sp
or
.sp
.nf
.ft CW
  cc tkXAppInit.o mystuff.a libtkx.a libtk.a libtclx.a libtcl.a \\
     ${SYSLIBS} -o myapp
.ft R
.fi
'
.SS TclX_Init
.PP
Initializes Extended Tcl, adding the extended command set to the interpreter.
This is called from \fBTcl_AppInit\fR.
.PP
Parameters
.RS 2
\fBo \fIinterp\fR - A pointer to the interpreter to add the commands to.
.RE
.PP
Returns:
.RS 2
\fBTCL_OK\fR if all is ok, \fBTCL_ERROR\fR if an error occurred.
.RE
'
.SS TclXCmd_Init
.PP
Add the TclX command set to the interpreter, with the exception of the
TclX library management commands.  This is normally called by
\fBTclX_Init\fR and should only be used if you don't want the TclX library
handling.
.PP
Parameters
.RS 2
\fBo \fIinterp\fR - A pointer to the interpreter to add the commands to.
.RE
.PP
Returns:
.RS 2
\fBTCL_OK\fR if all is ok, \fBTCL_ERROR\fR if an error occurred.
.RE
'
.SS TclXLib_Init
.PP
Add the TclX library management commands to the interpreter.
This is normally called by \fBTclX_Init\fR.
.PP
Parameters
.RS 2
\fBo \fIinterp\fR - A pointer to the interpreter to add the commands to.
.RE
.PP
Returns:
.RS 2
\fBTCL_OK\fR if all is ok, \fBTCL_ERROR\fR if an error occurred.
.RE
'
.SS TclX_Shell
.PP
The function is used when a \fBmain\fR other that the default one in
\fBlibtclx.a\fR is required.
This function parses the command line according to the TclX shell
specification.  It creates an interpreter and calls the function
\fBTcl_AppInit\fR to initialize any application specific commands.
It then either evaluates the command of script specified on the
command line or enters an interactive command loop.  No other TclX
initialization function should be called directly when this function is
used.

