'\"
'\" Copyright (c) 1989-1993 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /usr/cvs/NEOSOFT/inet_workstation/tcl7.3/tcl7.3/doc/AddErrInfo.3,v 2.0 1994/12/23 20:10:32 karl Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Tcl/Tk
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'       .TH \\$1 1 \\*(^3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\*(^3 \\$4
.if '\\$2'tcl'        .TH \\$1 n \\*(^3 Tcl "Tcl Built-In Commands"
.if '\\$2'tk'         .TH \\$1 n \\*(^3 Tk "Tk Commands"
.if '\\$2'tclc'        .TH \\$1 3 \\*(^3 Tcl "Tcl Library Procedures"
.if '\\$2'tkc'         .TH \\$1 3 \\*(^3 Tk "Tk Library Procedures"
.if '\\$2'tclcmds'         .TH \\$1 1 \\*(^3 Tk "Tcl Applications"
.if '\\$2'tkcmds'         .TH \\$1 1 \\*(^3 Tk "Tk Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_AddErrorInfo tclc
.BS
.SH NAME
Tcl_AddErrorInfo, Tcl_SetErrorCode, Tcl_PosixError \- record information about errors
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
\fBTcl_AddErrorInfo\fR(\fIinterp, message\fR)
.sp
\fBTcl_SetErrorCode\fR(\fIinterp, element, element, ...\fB (char *) NULL\fR)
.sp
char *
\fBTcl_PosixError\fR(\fIinterp\fR)
.SH ARGUMENTS
.AS Tcl_Interp *message
.AP Tcl_Interp *interp in
Interpreter in which to record information.
.AP char *message in
Identifying string to record in \fBerrorInfo\fR variable.
.AP char *element in
String to record as one element of \fBerrorCode\fR variable.
Last \fIelement\fR argument must be NULL.
.BE

.SH DESCRIPTION
.PP
These procedures are used to manipulate two global variables
that hold information about errors.
The variable \fBerrorInfo\fR holds a stack trace of the
operations that were in progress when an error occurred, and
is intended to be human-readable.
The variable \fBerrorCode\fR holds a list of items that
are intended to be machine-readable.
The first item in \fBerrorCode\fR identifies the class of
error that occurred (e.g. POSIX means an error occurred in
a POSIX system call) and additional elements in \fBerrorCode\fR
hold additional pieces of information that depend on the class.
See the Tcl overview manual entry for details on the various
formats for \fBerrorCode\fR.
.PP
The \fBerrorInfo\fR variable is gradually built up as an
error unwinds through the nested operations.
Each time an error code is returned to \fBTcl_Eval\fR
it calls the procedure \fBTcl_AddErrorInfo\fR to add
additional text to \fBerrorInfo\fR describing the
command that was being executed when the error occurred.
By the time the error has been passed all the way back
to the application, it will contain a complete trace
of the activity in progress when the error occurred.
.PP
It is sometimes useful to add additional information to
\fBerrorInfo\fR beyond what can be supplied automatically
by \fBTcl_Eval\fR.
\fBTcl_AddErrorInfo\fR may be used for this purpose:
its \fImessage\fR argument contains an additional
string to be appended to \fBerrorInfo\fR.
For example, the \fBsource\fR command calls \fBTcl_AddErrorInfo\fR
to record the name of the file being processed and the
line number on which the error occurred;  for Tcl procedures, the
procedure name and line number within the procedure are recorded,
and so on.
The best time to call \fBTcl_AddErrorInfo\fR is just after
\fBTcl_Eval\fR has returned \fBTCL_ERROR\fR.
In calling \fBTcl_AddErrorInfo\fR, you may find it useful to
use the \fBerrorLine\fR field of the interpreter (see the
\fBTcl_Interp\fR manual entry for details).
.PP
The procedure \fBTcl_SetErrorCode\fR is used to set the
\fBerrorCode\fR variable.
Its \fIelement\fR arguments give one or more strings to record
in \fBerrorCode\fR:  each \fIelement\fR will become one item
of a properly-formed Tcl list stored in \fBerrorCode\fR.
\fBTcl_SetErrorCode\fR is typically invoked just before returning
an error.
If an error is returned without calling \fBTcl_SetErrorCode\fR
then the Tcl interpreter automatically sets \fBerrorCode\fR
to \fBNONE\fR.
.PP
\fBTcl_PosixError\fR
sets the \fBerrorCode\fR variable after an error in a POSIX kernel call.
It reads the value of the \fBerrno\fR C variable and calls
\fBTcl_SetErrorCode\fR to set \fBerrorCode\fR in the
\fBPOSIX\fR format.
In addition, \fBTcl_PosixError\fR returns a human-readable
diagnostic message for the error (this is the same value that
will appear as the third element in \fBerrorCode\fR).
It may be convenient to include this string as part of the
error message returned to the application in \fIinterp->result\fR.
.PP
It is important to call the procedures described here rather than
setting \fBerrorInfo\fR or \fBerrorCode\fR directly with
\fBTcl_SetVar\fR.
The reason for this is that the Tcl interpreter keeps information
about whether these procedures have been called.
For example, the first time \fBTcl_AppendResult\fR is called
for an error, it clears the existing value of \fBerrorInfo\fR
and adds the error message in \fIinterp->result\fR to the variable
before appending \fImessage\fR;  in subsequent calls, it just
appends the new \fImessage\fR.
When \fBTcl_SetErrorCode\fR is called, it sets a flag indicating
that \fBerrorCode\fR has been set;  this allows the Tcl interpreter
to set \fBerrorCode\fR to \fBNONE\fB if it receives an error return
when \fBTcl_SetErrorCode\fR hasn't been called.
.PP
If the procedure \fBTcl_ResetResult\fR is called, it clears all
of the state associated with \fBerrorInfo\fR and \fBerrorCode\fR
(but it doesn't actually modify the variables).
If an error had occurred, this will clear the error state to
make it appear as if no error had occurred after all.

.SH "SEE ALSO"
Tcl_ResetResult, Tcl_Interp

.SH KEYWORDS
error, stack, trace, variable
