/*
 * win/dpSock.c --
 *
 *  This file implements the few windows-specific routines for the
 *  socket code.
 *
 * Copyright (c) 1995-1996 Cornell University.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include "generic/dpInt.h"
#include "generic/dpPort.h"


/*
 *--------------------------------------------------------------
 *
 * DppCloseSocket --
 *
 *	Close the socket passed in.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	None
 *
 *--------------------------------------------------------------
 */
int
DppCloseSocket (sock)
    DpSocket sock;
{
    return closesocket (sock);
}


/*
 *--------------------------------------------------------------
 *
 * DppSetBlock --
 *
 *	Put the socket into a blocking or non-blocking state.
 *	Note that the way Microsoft phrases it, turning off
 *	blocking requires a "1" (enabling non-blocking mode...)
 *	<sigh>
 *
 * Results:
 *	None
 *
 * Side effects:
 *	None
 *
 *--------------------------------------------------------------
 */
int
DppSetBlock (sock, block)
    DpSocket sock;
    int block;
{
    int result;
    u_long val = 0;
    
    if (block) {
	/* Set blocking mode */
	result = ioctlsocket(sock, FIONBIO, &val);
    } else {
	/* Set non-blocking mode */
	val = 1;
	result = ioctlsocket(sock, FIONBIO, &val);
    }
    return result;
}


/*
 *--------------------------------------------------------------
 *
 * DppGetErrno --
 *
 *	Returns the value of the errno variable for the last error
 *	that occurred.
 *
 * Results:
 *	POSIX error number.
 *
 * Side effects:
 *	Changes the Tcl global variable errno.
 *
 *--------------------------------------------------------------
 */
int
DppGetErrno ()
{
    int err;
    int posix;

    err = WSAGetLastError();
    TclWinConvertWSAError(err);
    posix = Tcl_GetErrno();
    return posix;
}


/*
 *--------------------------------------------------------------
 *
 * DppAppendError --
 *
 *	Appends a human readable error string into the interp->result
 *	corresponding the last socket error.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	None.
 *
 *--------------------------------------------------------------
 */
 /*
void
DppAppendError (interp)
    Tcl_Interp *interp;
{
    char str[32];

    switch (WSAGetLastError()) {
	case WSAENETDOWN:
	    Tcl_AppendResult(interp, "The Windows Sockets implementation ",
	    	    "has detected that the network subsystem has failed.",
	    	    NULL);
	    break;

	case WSAEAFNOSUPPORT:
	    Tcl_AppendResult(interp, "Internet addresses are not supported.",
	    	    NULL);
	    break;

	case WSAEINPROGRESS:
	    Tcl_AppendResult(interp, "A blocking Windows Sockets operation ",
	    	    "is in progress.", NULL);
	    break;

	case WSAEMFILE:
	    Tcl_AppendResult(interp, "No more file descriptors are available.",
	    	    NULL);
	    break;

	case WSAEPROTONOSUPPORT:
	    Tcl_AppendResult(interp, "IP is not supported by your winsock.dll",
	    	    NULL);
	    break;

	case WSAEADDRINUSE :
	    Tcl_AppendResult (interp, "The specified address is already in ",
	    	    "use. Use \"fconfigure ... reuseAddr\" to allow addresses ",
	    	    "to be reused", NULL);
	    break;

	case WSAENOBUFS:
	    Tcl_AppendResult (interp, "Not enough buffers available, too ",
	    	    "many connections.", NULL);
	    break;

	default:
	    sprintf (str, "%d", WSAGetLastError());
	    Tcl_AppendResult(interp, "Unknown return value from ",
		    "WSAGetLastError().  Return value ",
		    "was ", str, ". Please send this message to ",
		    "tcl-dp@cs.cornell.edu", NULL);
	    break;
	}
}
*/

