

#@package: modal_dialog2 modal_dialog_bitmap

package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# $Id: modal2.tcl,v 1.1.1.1 1997/01/15 23:54:57 kunkee Exp $
#

# modal_dialog msgArgs list list ...
#
# Create a modal dialog box with a message and any number of buttons at
# the bottom.
#
# Arguments:
#    msgArgs -	List of arguments to use when creating the message of the
#		dialog box (e.g. text, justifcation, etc.)
#
#    list -	A two-element list that describes one of the buttons that
#		will appear at the bottom of the dialog.  The first element
#		gives the text to be displayed in the button and the second
#		gives the value to be returned when the button is invoked.
#               If the second element doesn't exist, the first is returned.
#
#modal_dialog_bitmap @~/icons/skull.xbm {-text {Modal dialog.} -aspect 250 -justify left} {OK ok} {Cancel slag_off}
#

proc modal_dialog_bitmap {bitmap msgArgs args} {
    global modalDialogResult

    set w ".modal_dialog"
    catch {destroy $w}
    toplevel $w -class Dialog
    wm minsize $w 1 1
    wm title $w "Dialog box"
    wm iconname $w "Dialog"

    # Create two frames in the main window. The top frame will hold the
    # message and the bottom one will hold the buttons.  Arrange them
    # one above the other, with any extra vertical space split between
    # them.

    frame $w.top -relief raised -border 1
    frame $w.bot -relief raised -border 1
    pack $w.top -side top -fill both -expand yes
    pack  $w.bot -side top -fill both -expand yes
    
    # Create the message widget and arrange for it to be centered in the
    # top frame.
    
    label $w.top.label -bitmap $bitmap
    pack $w.top.label -side left -expand yes -padx 5 -pady 5

    eval message $w.top.msg -justify center \
	    -font -Adobe-times-medium-r-normal--*-180* $msgArgs
    pack $w.top.msg -side left -expand yes -padx 5 -pady 5
    
    # Create as many buttons as needed and arrange them from left to right
    # in the bottom frame.  Embed the left button in an additional sunken
    # frame to indicate that it is the default button, and arrange for that
    # button to be invoked as the default action for clicks and returns in
    # the dialog.

    if {[llength $args] > 0} {
	set arg [lindex $args 0]
        set resultText [lindex $arg 1]
        if {$resultText == ""} {
            set resultText [lindex $arg 0]
        }
	frame $w.bot.0 -relief sunken -border 1
	pack $w.bot.0 -side left -expand yes -padx 20 -pady 20
	button $w.bot.0.button -text [lindex $arg 0] \
		-command "destroy $w; set modalDialogResult \"$resultText\""
	pack $w.bot.0.button -expand yes -padx 12 -pady 12
	bind $w <Return> "destroy $w; set modalDialogResult \"$resultText\""
	focus $w

	set i 1
	foreach arg [lrange $args 1 end] {
            set resultText [lindex $arg 1]
            if {$resultText == ""} {
                set resultText [lindex $arg 0]
            }
	    button $w.bot.$i -text [lindex $arg 0] \
		    -command "destroy $w; set modalDialogResult \"$resultText\""
	    pack $w.bot.$i -side left -expand yes -padx 20
	    set i [expr $i+1]
	}
    }
    bind $w <Any-Enter> [list focus $w]
    bind $w <Visibility> "grab $w; focus $w"
    center_window $w
    tkwait window $w
    return $modalDialogResult
}

