

#@package: neologo about_neosoft

package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# $Id: neologo.tcl,v 1.1.1.1 1997/01/15 23:54:57 kunkee Exp $
#

proc about_neosoft {application year} {
    global NEOSOFT_ENV

    set w .about_neosoft
    catch {destroy $w}
    toplevel $w

    frame $w.titleFrame -relief raised

    label $w.titleFrame.neologo \
        -bitmap @$NEOSOFT_ENV(desktopBitmaps)/neologo.medium.xbm
    label $w.titleFrame.neosoft \
        -bitmap @$NEOSOFT_ENV(desktopBitmaps)/large-neosoft.xbm
    pack $w.titleFrame.neologo -side left 
    pack $w.titleFrame.neosoft -side left
    pack $w.titleFrame -side top

    message $w.message -aspect 500 \
        -text "$application\nCopyright (C) $year NeoSoft.  All Rights Reserved" \
        -font "*-medium-o-normal--*-240-*"
    pack $w.message -side top -fill both

    frame $w.buttonFrame
    button $w.buttonFrame.okButton -text "OK" -command "destroy $w"
    pack $w.buttonFrame.okButton
    pack $w.buttonFrame -side top -fill both
}

