#@package: notepad Notepad

package require Itcl
package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# Notepad class
#
# $Id: notepad.tcl,v 1.1.1.1 1997/01/15 23:54:57 kunkee Exp $
#

require TextClass

itcl_class Notepad {

    inherit TextClass

    constructor {config} {
	notepad
    }

    proc load_file {fileName} {
	wm title $w "NeoSoft Notepad - $fileName"
	empty_out_text
	load $fileName
	set currentFileName $fileName
    }

    method append_file {fileName} {

	if {[catch {set textFp [open $fileName]} result] == 1} {
	    return
	}
	$widgetName insert 1.0 [read $textFp]
	close $textFp
    }

    method save_file {fileName} {
        set textfp [open $fileName w]
        puts $textfp [$textWidget get 1.0 end] nonewline
        close $textfp
    }

    method add_menus {} {
	frame $w.menuFrame
	pack $w.menuFrame -side top -fill both

	create_pulldown_menu $w file File 0
	add_pulldown command $w file About \
	    -command "about_neosoft {NeoSoft Notepad} 1992-1996" -underline 0
	add_pulldown command $w file New -underline 0
	add_pulldown command $w file Open -command load_button -underline 0
	add_pulldown command $w file Save -underline 0 -command save_button
	add_pulldown command $w file "Save As..." -underline 5 \
	    -command save_as_button
	add_pulldown command $w file Exit -command exit_notepad -underline 0

	bind_pulldown_menus $w
    }

    proc save_as_button {} {
	fileselect save_this_file "Save notepad as..."
    }

    proc save_button {} {
	global currentFileName

	save_text_widget $w.t $currentFileName
    }

    proc save_this_file {frame fileName} {
	destroy $frame
	save_text_widget $w.t [file root $fileName]
    }

    proc load_button {} {
	fileselect load_this_file "Load notepad..."
    }

    proc empty_out_text {w} {
	$w delete 1.0 end
    }

    proc notepad {{topnote .notepad}} {
	set w $topnote

	catch {destroy $w}
	toplevel $w

	set neoFrame $w.neoFrame
	frame $neoFrame
	label $neoFrame.label -bitmap @/usr/neosoft/icons/neosoft.xbm \
	    -foreground blue4
	pack $neoFrame.label -side left
	label $neoFrame.idlabel -text "Notepad"
	pack $neoFrame.idlabel -side left
	pack $neoFrame -side top -fill both

	add_menus

	frame $w.titlebar -relief raised

	wm title $w "NeoSoft Notepad"
	wm iconname $w "Notepad"

	# define the text widget
	text $w.t -relief raised -bd 2 -yscrollcommand "$w.s set" -setgrid true \
		-width 70 -height 28 -wrap word \
		-exportselection true

	set textWidget $w.t

	scrollbar $w.s -relief flat -command "$w.t yview"
	pack $w.s -side right -fill y
	pack $w.t -expand 1 -fill both

	# Set up display styles

	$w.t mark set insert 0.0
	bind $w <Any-Enter> "focus $w.t"
    }

    proc exit_notepad {} {
	destroy .
    }

    public w
    public currentFileName
}

