#@package: PasswordBox PasswordBox

package require Itcl
package require Tk

#
# Copyright (C) 1992-1996 NeoSoft.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted, provided
# that the above copyright notice appear in all copies.  NeoSoft makes no 
# representations about the suitability of this software for any purpose.
# It is provided "as is" without express or implied warranty.

#
# This file defines a PasswordBox class which will create a password
# widget that types asterisks into the entry widget as the user types keys,
# rather than the keys the user typed.
#
# $Id: tkpassword.tcl,v 1.1.1.1 1997/01/15 23:54:57 kunkee Exp $
#

itcl_class PasswordBox {

    method insert_char {char key} {
	if {$char == ""} return

	append password $char

	$widgetName.password insert end "*"
    }

    method delete_char {} {

        if {$password == ""} return
	set length [clength $password]
	if {$length == 0} return
	if {$length == 1} {
	    set password ""
	    $widgetName.password delete 0 end
	    return
	}
	set password [crange $password 0 {[clength $password] - 2}]
	$widgetName.password delete 0
    }

    method run {config} {
	set password ""
	catch {destroy $widgetName}
	toplevel $widgetName
	wm minsize $widgetName 1 1
	wm title $widgetName "Password Entry"

	label $widgetName.label -text "Enter Password:"
	pack $widgetName.label

	entry $widgetName.password -relief raised
	pack $widgetName.password

	focus $widgetName.password

	bind $widgetName.password <Key> "$this insert_char %A %K"
	bind $widgetName.password <BackSpace> "$this delete_char"
	bind $widgetName.password <Delete> "$this delete_char"
	bind $widgetName.password <Return> "destroy $widgetName"

	center_window $widgetName

	tkwait window $widgetName
	return $password
    }

    method configure {config} {
    }

    public password ""
    public widgetName ".password"
}

