'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) global.n 1.5 96/03/25 20:16:10
'\" 
.so man.macros
'\"	# CS - begin display of code example
.de CS
.in +0.4i
.nf
\fC
..
'\"	# CE - end display of code example
.de CE
\fP
.fi
.in -0.4i
..
.TH global n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
global \- Access global variables
.SH SYNOPSIS
\fBglobal \fIvarname \fR?\fIvarname ...\fR?
.BE

.SH DESCRIPTION
.PP
This command is ignored unless a Tcl procedure is being interpreted.
If so then it declares the given \fIvarname\fR's to be global variables
rather than local ones.  For the duration of the current procedure
(and only while executing in the current procedure), any reference to
any of the \fIvarname\fRs will refer to the global variable by the same
name.
.PP
.VS
Global variables are found with respect to the current namespace context.
To access global variables in another namespace, simply include namespace
qualifiers in the \fIvarname\fR arguments.  For example,
.CS
set x "ignored"
set y 1

namespace foo {
    variable x 0
    variable y "ignored"

    proc checkx {} {
        global x
        return $x
    }
    proc checky {} {
        global ::y
        return $y
    }
}
.CE
The command "foo::checkx" will return the value of "foo::x" which
is "0".  The command "foo::checky" will return the value of "::y"
which is "1".
.VE

.SH KEYWORDS
global, procedure, variable
