'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" SCCS: @(#) info.n 1.14 96/08/26 13:00:01
'\" 
.so man.macros
.TH info n 7.5 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
info \- Return information about the state of the Tcl interpreter
.SH SYNOPSIS
\fBinfo \fIoption \fR?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command provides information about various internals of the Tcl
interpreter.
The legal \fIoption\fR's (which may be abbreviated) are:
.TP
\fBinfo args \fIprocname\fR
Returns a list containing the names of the arguments to procedure
\fIprocname\fR, in order.  \fIProcname\fR must be the name of a
Tcl command procedure.
.TP
\fBinfo body \fIprocname\fR
Returns the body of procedure \fIprocname\fR.  \fIProcname\fR must be
the name of a Tcl command procedure.
.TP
\fBinfo cmdcount\fR
Returns a count of the total number of commands that have been invoked
in this interpreter.
.TP
\fBinfo commands \fR?\fIpattern\fR?
If \fIpattern\fR isn't specified, returns a list of names of all the
Tcl commands
.VS
in the current namespace context,
.VE
including both the built-in commands written in C and
the command procedures defined using the \fBproc\fR command.
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBinfo complete \fIcommand\fR
Returns 1 if \fIcommand\fR is a complete Tcl command in the sense of
having no unclosed quotes, braces, brackets or array element names,
If the command doesn't appear to be complete then 0 is returned.
This command is typically used in line-oriented input environments
to allow users to type in commands that span multiple lines;  if the
command isn't complete, the script can delay evaluating it until additional
lines have been typed to complete the command.
.TP
\fBinfo context\fR
.VS
Returns the fully-qualified name for the current namespace context.
The global namespace ("\fC::\fR") is represented as a null string,
making it easy to build namespace names like "\fC[info context]::foo\fR".
.VE
.TP
\fBinfo default \fIprocname arg varname\fR
\fIProcname\fR must be the name of a Tcl command procedure and \fIarg\fR
must be the name of an argument to that procedure.  If \fIarg\fR
doesn't have a default value then the command returns \fB0\fR.
Otherwise it returns \fB1\fR and places the default value of \fIarg\fR
into variable \fIvarname\fR.
.TP
\fBinfo exists \fIvarName\fR
Returns \fB1\fR if the variable named \fIvarName\fR exists in the
current context (either as a global or local variable), returns \fB0\fR
otherwise.
.TP
\fBinfo globals \fR?\fIpattern\fR?
If \fIpattern\fR isn't specified, returns a list of all the names
of currently-defined global variables
.VS
in the current namespace context.
.VE
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBinfo hostname\fR
Returns the name of the computer on which this invocation is being
executed.
.TP
\fBinfo level\fR ?\fInumber\fR?
If \fInumber\fR is not specified, this command returns a number
giving the stack level of the invoking procedure, or 0 if the
command is invoked at top-level.  If \fInumber\fR is specified,
then the result is a list consisting of the name and arguments for the
procedure call at level \fInumber\fR on the stack.  If \fInumber\fR
is positive then it selects a particular stack level (1 refers
to the top-most active procedure, 2 to the procedure it called, and
so on); otherwise it gives a level relative to the current level
(0 refers to the current procedure, -1 to its caller, and so on).
See the \fBuplevel\fR command for more information on what stack
levels mean.
.TP
\fBinfo library\fR
Returns the name of the library directory in which standard Tcl
scripts are stored.
This is actually the value of the \fBtcl_library\fR
variable and may be changed by setting \fBtcl_library\fR.
See the \fBtclvars\fR manual entry for more information.
.TP
\fBinfo loaded \fR?\fIinterp\fR?
Returns a list describing all of the packages that have been loaded into
\fIinterp\fR with the \fBload\fR command.
Each list element is a sub-list with two elements consisting of the
name of the file from which the package was loaded and the name of
the package.
For statically-loaded packages the file name will be an empty string.
If \fIinterp\fR is omitted then information is returned for all packages
loaded in any interpreter in the process.
To get a list of just the packages in the current interpreter, specify
an empty string for the \fIinterp\fR argument.
.TP
\fBinfo locals \fR?\fIpattern\fR?
If \fIpattern\fR isn't specified, returns a list of all the names
of currently-defined local variables, including arguments to the
current procedure, if any.
Variables defined with the \fBglobal\fR and \fBupvar\fR commands
will not be returned.
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBinfo nameofexecutable\fR
Returns the full path name of the binary file from which the application
was invoked.  If Tcl was unable to identify the file, then an empty
string is returned.
.TP
\fBinfo namespace\fR \fIoption\fR ?\fIarg arg ...\fR?
.VS
A collection of queries regarding namespaces.  The \fIoption\fR
argument should be one of the following:
.VE
.RS
.TP
\fBinfo namespace all\fR ?\fIpattern\fR?
.VS
Returns a list of all child namespaces in the current namespace
context.  This includes the direct children of the current namespace
and other children that are visible because their parent namespace
was imported.  The direct children have simple names and appear
first on the list; the imported children have fully-qualified names
and appear at the end of the list.
.VE
.TP
\fBinfo namespace children\fR ?\fIname\fR?
.VS
Returns a list of all child namespaces in the namespace \fIname\fR.
If \fIname\fR is not specified, then children are reported in the
current namespace context.  Unlike the "\fBinfo namespace all\fR"
command, this command reports only the children directly contained
within the namespace, and it reports them with fully-qualified
names.
.VE
.TP
\fBinfo namespace parent\fR ?\fIname\fR?
.VS
Returns the fully-qualified name of the parent for namespace \fIname\fR.
If \fIname\fR is not specified, then the parent of the current
namespace context is reported.
.VE
.TP
\fBinfo namespace qualifiers\fR \fIstring\fR
.VS
Returns the leading namespace qualifiers for the specified string.
Qualifiers are namespace names separated by the "\fC::\fR" string.
For the string "::foo::bar::x", this command would return "::foo::bar".
.VE
.TP
\fBinfo namespace tail\fR \fIstring\fR
.VS
Returns the simple name at the end of qualified string.  Qualifiers
are namespace names separated by the "\fC::\fR" string.
For the string "::foo::bar::x", this command would return "x".
.VE
.RE
.TP
\fBinfo patchlevel\fR
Returns the value of the global variable \fBtcl_patchLevel\fR; see
the \fBtclvars\fR manual entry for more information.
.TP
\fBinfo procs \fR?\fIpattern\fR?
If \fIpattern\fR isn't specified, returns a list of all the
names of Tcl command procedures
.VS
in the current namespace context.
.VE
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBinfo protection\fR ?\fB-command\fR? ?\fB-variable\fR? \fIname\fR
.VS
Returns the current protection level (public, protected or private)
for the specified \fIname\fR.  The protection level is set using
the \fBpublic\fR, \fBprotected\fR and \fBprivate\fR commands when
a command or variable is created.  The protection level indicates
whether or not a command or variable can be accessed from other
namespace contexts.  See the documentation on \fBnamespace\fR for
the rules regarding command/variable access.
If no flags specified, or if the \fB-command\fR flag is included,
\fIname\fR is treated as a command name.
If the \fB-variable\fR flag is included, \fIname\fR is treated as
a variable name.
.VE
.TP
\fBinfo script\fR
If a Tcl script file is currently being evaluated (i.e. there is a
call to \fBTcl_EvalFile\fR active or there is an active invocation
of the \fBsource\fR command), then this command returns the name
of the innermost file being processed.  Otherwise the command returns an
empty string.
.TP
\fBinfo sharedlibextension\fR
Returns the extension used on this platform for the names of files
containing shared libraries (for example, \fB.so\fR under Solaris).
If shared libraries aren't supported on this platform then an empty
string is returned.
.TP
\fBinfo tclversion\fR
Returns the value of the global variable \fBtcl_version\fR; see
the \fBtclvars\fR manual entry for more information.
.TP
\fBinfo vars\fR ?\fIpattern\fR?
If \fIpattern\fR isn't specified,
returns a list of all the names of currently-visible variables, including
both locals and currently-visible globals.
If \fIpattern\fR is specified, only those names matching \fIpattern\fR
are returned.  Matching is determined using the same rules as for
\fBstring match\fR.
.TP
\fBinfo which\fR ?\fB-command\fR? ?\fB-variable\fR? ?\fB-namespace\fR? \fIname\fR
.VS
Resolves the specified \fIname\fR in the current namespace context
and returns a fully-qualified name which uniquely identifies it.
See the documentation on \fBnamespace\fR for the rules regarding
name resolution.
If no flags specified, or if the \fB-command\fR flag is included,
\fIname\fR is treated as a command name.
If the \fB-variable\fR flag is included, \fIname\fR is treated as
a variable name.
If the \fB-namespace\fR flag is included, \fIname\fR is treated as
a namespace name.
.VE

.SH KEYWORDS
command, information, interpreter, level, procedure, variable
