# Test file for:
#   auto_mkindex
#
# This file provides example cases for testing the Tcl autoloading
# facility.  Things are much more complicated with [incr Tcl] namespaces.
# The "auto_mkindex" facility can no longer be built on top of a simple
# regular expression parser.  It must recognize constructs like this:
#
#   namespace foo {
#       public proc test1 {x y} {return "test1"}
#       protected proc ::top {} {return "top"}
#       namespace bar {
#           proc baz {} {return "baz"}
#       }
#   }
#
# Note that proc definitions can be nested inside of namespaces, and
# might be prefaced by a public/protected/private declaration.
#
# Copyright (c) 1996 Lucent Technologies

#
# Real files might have variable references and some simple commands
# mixed in.  Commands like "set", "puts" and "foreach" should be ignored.
#
set numbers(one) 1
set numbers(two) 2

set home $env(HOME)

puts "AUTO-PATH:"
set count 0
foreach file [lsort $auto_path] {
    puts "-> $file"
    incr count
}

#
# Should be able to handle simple proc definitions, even if
# they are prefaced with white space.
#
proc simple {mesg} {
    return "simple: $mesg"
}
  proc simple2 {x y} {
      return "simple2: $x $y"
  }

#
# Should be able to handle public/protected/private declarations.
#
public		proc pubp {x} {return "pubp: $x"}
protected	proc prop {x} {return "prop: $x"}
private		proc prip {x} {return "prip: $x"}

::public	::proc ppubp {x} {return "ppubp: $x"}

#
# Should be able to handle ensemble declarations.
#
ensemble composite {
    option op1 {x} {return "op1: $x"}
    option op2 {x} {return "op2: $x"}
}

#
# Should be able to proc declarations within namespaces, even
# if they have explicit namespace paths.
#
namespace buried {
    proc inside {args} {return "inside: $args"}
    proc ::top {args} {return "top: $args"}

    namespace under {
        proc neath {args} {return "neath: $args"}
    }
    namespace deep {
        proc within {args} {return "within: $args"}
    }

    public {
       proc pub::one {x} {return "one: $x"}
       proc pub::two {x y} {return "two: $x $y"}
    }
}

#
# Should be able to handle names with nasty characters.
#
proc nasty$$ {args} {
	return "nasty: $args"
}
