/*
 * tkMacTclCode.r --
 *
 *	This file creates resources for embedding the Tcl startup
 *  code in TEXT resources of either a Library or a statically bound
 *  executible...
 *
 * Copyright (c) 1993-1994 Lockheed Missle & Space Company, AI Center
 * Copyright (c) 1995-1996 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * -------------- Modified for ITCL 2.2 ---------------
 * Jim Ingham Lucent Technologies 1996
 * ----------------------------------------------------
 *
 * SCCS: @(#) tkMacResource.r 1.23 96/10/03 17:52:10
 */

#include <Types.r>
#include <SysTypes.r>

/*
 * The folowing include and defines help construct
 * the version string for Tcl.
 */

#define RESOURCE_INCLUDED
#include "tcl.h"
#include "tk.h"

#if (TK_RELEASE_LEVEL == 0)
#   define RELEASE_LEVEL alpha
#elif (TK_RELEASE_LEVEL == 1)
#   define RELEASE_LEVEL beta
#elif (TK_RELEASE_LEVEL == 2)
#   define RELEASE_LEVEL final
#endif

#if (TK_RELEASE_LEVEL == 2)
#   define MINOR_VERSION (TK_MINOR_VERSION * 16) + TK_RELEASE_SERIAL
#else
#   define MINOR_VERSION TK_MINOR_VERSION * 16
#endif

/* 
 * The mechanisim below loads Tcl source into the resource fork of the
 * application.  The example below creates a TEXT resource named
 * "Init" from the file "init.tcl".  This allows applications to use
 * Tcl to define the behavior of the application without having to
 * require some predetermined file structure - all needed Tcl "files"
 * are located within the application.  To source a file for the
 * resource fork the source command has been modified to support
 * sourcing from resources.  In the below case "source -rsrc {Init}"
 * will load the TEXT resource named "Init".
 */

#define TK_LIBRARY_RESOURCES 3000

read 'TEXT' (TK_LIBRARY_RESOURCES+1, "tk", purgeable, preload) "::library:tk.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+2, "button", purgeable, preload) "::library:button.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+3, "dialog", purgeable, preload) "::library:dialog.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+4, "entry", purgeable, preload) "::library:entry.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+5, "focus", purgeable, preload) "::library:focus.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+6, "listbox", purgeable, preload) "::library:listbox.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+7, "menu", purgeable, preload) "::library:menu.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+8, "optionMenu", purgeable, preload) "::library:optMenu.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+9, "palette", purgeable, preload) "::library:palette.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+10, "scale", purgeable, preload) "::library:scale.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+11, "scrollbar", purgeable, preload) "::library:scrlbar.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+12, "tearoff", purgeable, preload) "::library:tearoff.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+13, "text", purgeable, preload) "::library:text.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+14, "tkerror", purgeable, preload) "::library:bgerror.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+15, "Console", purgeable, preload) "::library:console.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+16, "msgbox", purgeable, preload) "::library:msgbox.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+17, "comdlg", purgeable, preload) "::library:comdlg.tcl";
read 'TEXT' (TK_LIBRARY_RESOURCES+18, "prolog", purgeable, preload) "::library:prolog.ps";

