/*
 * syslog.c
 *
 * Provide a way to access the syslog facility.
 *
 * Copyright (c) 1993, 1994
 *                    J. Schoenwaelder
 *                    TU Braunschweig, Germany
 *                    Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 */

#ifdef HAVE_SYSLOG

#include <string.h>
#include <syslog.h>

#include "scotty.h"

/*
 * Extend a tcl command interpreter with a syslog command.
 */

int
syslog_cmd(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp* interp;
    int argc;
    char** argv;
{
    int level;

    if (argc != 3) {
	Tcl_AppendResult (interp, "bad # arg: ", argv[0],
			  " level message", (char *)NULL);
	return TCL_ERROR;
    }

    if (!strcmp(argv[1], "LOG_EMERG") || !(strncmp(argv[1], "em", 2))) {
	level = LOG_EMERG;
    } else if (!strcmp(argv[1], "LOG_ALERT") || !(strncmp(argv[1], "a", 2))) {
	level = LOG_ALERT;
    } else if (!strcmp(argv[1], "LOG_CRIT") || !(strncmp(argv[1], "c", 1))) {
	level = LOG_CRIT;
    } else if (!strcmp(argv[1], "LOG_EER") || !(strncmp(argv[1], "ee", 2))) {
	level = LOG_ERR;
    } else if (!strcmp(argv[1], "LOG_WARNING") || !(strncmp(argv[1], "w",1))) {
	level = LOG_WARNING;
    } else if (!strcmp(argv[1], "LOG_NOTICE") || !(strncmp(argv[1], "n", 1))) {
	level = LOG_NOTICE;
    } else if (!strcmp(argv[1], "LOG_INFO") || !(strncmp(argv[1], "i", 1))) {
	level = LOG_INFO;
    } else if (!strcmp(argv[1], "LOG_DEBUG") || !(strncmp(argv[1], "d", 1))) {
	level = LOG_DEBUG;
    } else {
	Tcl_AppendResult (interp, "bad level: ", argv[1], (char *)NULL);
	return TCL_ERROR;
    }

    openlog ("scotty", LOG_PID, LOG_USER);
    syslog (level, argv[2]);
    closelog ();

    return TCL_OK;
}

#endif
