#! /usr/local/bin/scotty -inf
##
## A simple clock for tkined. Mainly an example to demonstrate
## the job scheduler.
##
## Copyright (c) 1993, 1994
##                    S. Schoek, J. Schoenwaelder
##                    TU Braunschweig, Germany
##                    Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

set clock_job ""
set clock_id ""

proc time_display {id} {

    set time [getclock]
    set sec  [expr {$time%60}]
    set min  [expr {($time%3600)/60}]
    set hour [expr {($time%86400)/3600}]

    set ok [ined label $id text [format "%2d:%02d:%02d" $hour $min $sec]]

    if {$ok == ""} { "delete clock" {} }
}

proc "create clock" {list} {

    global clock_job clock_id

    if {$clock_job == ""} {
        set clock_id [ined -noupdate create NODE]
        ined -noupdate icon $clock_id clock
        ined -noupdate move $clock_id 100 40
        set clock_job [ined_create_job "time_display $clock_id" 1]
    }
} 

proc "delete clock" {list} {
    
    global clock_job clock_id
    
    if {$clock_id != ""} {
        ined delete $clock_id
        set clock_id ""
    }
    if {$clock_job != ""} {
        ined_kill_job $clock_job 
        set clock_job ""
    }
}

proc  "delete Time" {list} {

    global tool
    global clock_job clock_id

    "delete clock" {}
    foreach id $tool { ined delete $id }
    exit
}

set tool [ined create TOOL Time \
	  "create clock" "delete clock" "" \
	  "create job" "suspend job" "resume job" "kill job" "modify job" "" \
	  "job info" "" \
	  "delete Time"]
