#
# Name
#
#   tkGrep_global.tcl
#
# Description
#
#   Contains global definitions used in tkGrep.tcl
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


#Define the Distribution Version
set tkGrep(DISTRIBUTION) "0.03"

# Define users environment variables.
set tkGrep(HOME) $env(HOME)
set tkGrep(USER_OPTION_DIR) "$tkGrep(HOME)/.tkWorld-$tkGrep(DISTRIBUTION)"
set tkGrep(USER_OPTION_FILE) "$tkGrep(USER_OPTION_DIR)/.tkGreprc"
set tkGrep(USER_EXAMPLE_FILE) "$tkGrep(USER_OPTION_DIR)/tkGrep.ex"
set tkGrep(FILENAME) ""
set tkGrep(REGEXP) ""
set tkGrep(IMAGE_DIR) "images"
set tkGrep(BROWSER) "tkLB"
set tkGrep(HELP_FILE) "file:/doc/tkGrep_help.html"
set tkGrep(COMMAND) ""

# Define the bitmap for the icon and its name.
wm iconbitmap . @$tkGrep(IMAGE_DIR)/tkGrep_icon.xbm
wm iconname . "tkGrep"

# Define the global image variables.
set tkGrep(IMAGE_ICON) [image create photo \
	-file $tkGrep(IMAGE_DIR)/tkGrep_icon.gif]
set tkGrep(IMAGE_CLIPBOARD) [image create photo \
	-file $tkGrep(IMAGE_DIR)/tkGrep_clipboard.gif]
set tkGrep(IMAGE_ERROR) [image create photo \
	-file $tkGrep(IMAGE_DIR)/tkWorld_error.gif]
foreach i "1 2 3 4 5" {
    set tkGrep(IMAGE_ANIMATE_$i) [image create photo \
	-file $tkGrep(IMAGE_DIR)/tkGrep_animate_$i.gif]
}

# Color globals.
set tkGrep(COLOR_FOREGROUND) #000000
set tkGrep(COLOR_BACKGROUND) #8da5c0
set tkGrep(COLOR_HIGHLIGHT) #fffff7098f9d
set tkGrep(ENTRY_DEFAULT_FOREGROUND) #000000
set tkGrep(ENTRY_DEFAULT_BACKGROUND) #ffffff
set tkGrep(ENTRY_ERROR_FOREGROUND) #000000
set tkGrep(ENTRY_ERROR_BACKGROUND) #fffff7098f9d
set tkGrep(LABEL_WIZARD_BACKGROUND) #fffff7098f9d

# Define the error messages.  

set tkGrep(ERROR_NOT_VALID_LIST) "Hmmmm, I cannot open all the files in\
your Filenames entry.  Perhaps  you have a directory in this entry?\
Remember grep cannot scan directories.  Otherwise check your spelling\
and make sure each file in this entry exists."
