#
# Name
#
#   tkLB_global.tcl
#
# Description
#
#   Contains global definitions used in tkLB.
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# Define the home directory
set tkLB(HOME) $env(HOME)

# Define where the image files live.
set tkLB(IMAGEDIR) "images"

# Define the gloabal image variables to load for the toolbar.
set tkLB(IMAGE_EXIT) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_exit.gif]
set tkLB(IMAGE_LEFT) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_left.gif]
set tkLB(IMAGE_RIGHT) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_right.gif]
set tkLB(IMAGE_UP) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_up.gif]
set tkLB(IMAGE_DOWN) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_down.gif]
set tkLB(IMAGE_TKLB) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_icon.gif]
set tkLB(IMAGE_FILLDOT) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_filldot.xbm]
set tkLB(IMAGE_OPENDOT) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_opendot.xbm]
set tkLB(IMAGE_FILLSQR) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_fillsqr.xbm]
set tkLB(IMAGE_OPENSQR) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_opensqr.xbm]
set tkLB(IMAGE_FILLDMD) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_filldmd.xbm]
set tkLB(IMAGE_OPENDMD) [image create bitmap \
	-file $tkLB(IMAGEDIR)/tkLB_opendmd.xbm]
set tkLB(IMAGE_ANIMATE_1) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_animate_1.gif]
set tkLB(IMAGE_ANIMATE_2) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_animate_2.gif]
set tkLB(IMAGE_ANIMATE_3) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_animate_3.gif]
set tkLB(IMAGE_ANIMATE_4) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_animate_4.gif]
set tkLB(IMAGE_ANIMATE_5) [image create photo \
	-file $tkLB(IMAGEDIR)/tkLB_animate_5.gif]

# Define color schemes.
set tkLB(BG_COLOR) #8fdea54ecdd2
set tkLB(FG_COLOR) #000000
set tkLB(HREF_FG_COLOR) #0000ff
set tkLB(HREF_SELECT_COLOR) #000098

# Define Display Fonts. 
#set tkLB(FONT_TXT) {-*-fixed-medium-*-*-*-14-*-*-*-*-*-*-*}
set tkLB(FONT_TXT) {-*-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*}
set tkLB(FONT_TITLE) {-*-times-bold-r-normal-*-*-240-*-*-*-*-*-*}
set tkLB(FONT_H1) {-*-helvetica-*-r-normal-*-*-270-*-*-*-*-*-*}
set tkLB(FONT_H2) {-*-helvetica-*-r-normal-*-*-220-*-*-*-*-*-*}
set tkLB(FONT_H3) {-*-helvetica-*-r-normal-*-*-190-*-*-*-*-*-*}
set tkLB(FONT_H4) {-*-helvetica-*-r-normal-*-*-160-*-*-*-*-*-*}
set tkLB(FONT_H5) {-*-helvetica-*-r-normal-*-*-130-*-*-*-*-*-*}
set tkLB(FONT_H6) {-*-helvetica-*-r-normal-*-*-100-*-*-*-*-*-*}
set tkLB(FONT_HR) {-*-terminal-*-*-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_BR) {-*-times-medium-r-*-*-14-160-*-*-*-*-*-*}
set tkLB(FONT_EM) {-*-times-medium-i-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_CODE) {-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*}
set tkLB(FONT_SAMP) {-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*}
set tkLB(FONT_KBD) {-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*}
set tkLB(FONT_VAR) {-*-times-medium-i-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_CITE) {-*-times-medium-i-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_STRONG) {-*-times-bold-r-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_B) {-*-times-bold-r-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_I) {-*-times-medium-i-*-*-*-140-*-*-*-*-*-*}
set tkLB(FONT_IT) {-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*}
set tkLB(FONT_PRE) {-*-Courier-Medium-R-Normal--*-130-*-*-*-*-*-*}

# Define help messages which appear when mouse enters the defined
#    widget.
set tkLB(HELP.top.left) "Back 1 Page"
set tkLB(HELP.top.right) "Forward 1 Page"
set tkLB(HELP.top.up) "Page Up"
set tkLB(HELP.top.down) "Page Down"
set tkLB(HELP.top.exit) "Exit Little Browser"
set tkLB(HELP.top.icon) "Kokopelli"
set tkLB(HELP.bottom.display.text) "Viewing HTML"

# Define the HTML tags which do not come in pairs.
set tkLB(SINGLE_TAG) "P BR HR IMG"

# Define tags which do not print automatically.
set tkLB(NOPRINT_LIST) "HTML /HTML BODY /BODY /OL /UL /DL"

# Initialize the file parameter.
set tkLB(HTML_FILE) ""
