#
# Name
#
#   tkREM_global.tcl
#
# Description
#
#   Contains global definitions used in tkREM.tcl
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#Define the Distribution Version
set tkREM(DISTRIBUTION) "0.03"

# Define users environment variables.
set tkREM(HOME) $env(HOME)
set tkREM(USER_OPTION_DIR) "$tkREM(HOME)/.tkWorld-$tkREM(DISTRIBUTION)"
set tkREM(USER_OPTION_FILE) "$tkREM(USER_OPTION_DIR)/.tkREMrc"
set tkREM(USER_EXAMPLE_FILE) "$tkREM(USER_OPTION_DIR)/tkREM.ex"
set tkREM(REGEXP) ""
set tkREM(IMAGE_DIR) "images"
set tkREM(BROWSER) "tkLB"
set tkREM(HELP_FILE) "file:/doc/tkREM_help.html"

# Define the bitmap for the icon and its name.
wm iconbitmap . @$tkREM(IMAGE_DIR)/tkREM_icon.xbm
wm iconname . "tkREM"

# Define the global image variables.
set tkREM(IMAGE_CLIPBOARD) [image create photo \
	-file $tkREM(IMAGE_DIR)/tkREM_clipboard.gif]
set tkREM(IMAGE_CLEAR) [image create photo \
	-file $tkREM(IMAGE_DIR)/tkREM_clear.gif]
set tkREM(IMAGE_HELP) [image create photo \
	-file $tkREM(IMAGE_DIR)/tkREM_button_help.gif]
set tkREM(IMAGE_EXIT) [image create photo \
	-file $tkREM(IMAGE_DIR)/tkREM_exit.gif]
set tkREM(IMAGE_ICON) [image create photo \
	-file $tkREM(IMAGE_DIR)/tkREM_icon.gif]

# Color globals.
set tkREM(COLOR_FOREGROUND) #000000
set tkREM(COLOR_BACKGROUND) #8da5c0
set tkREM(COLOR_HIGHLIGHT) #ee5eeed80000
set tkREM(ENTRY_DEFAULT_FOREGROUND) #000000
set tkREM(ENTRY_DEFAULT_BACKGROUND) #ffffff
set tkREM(ENTRY_ERROR_FOREGROUND) #000000
set tkREM(ENTRY_ERROR_BACKGROUND) #ffff00
