#
# Name
#
#   tkWinstall_global.tcl
#
# Description
#
#   Contains global definitions used in tkWinstall.tcl
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#Define the Distribution Version
set tkWinstall(DISTRIBUTION) "0.03"

# Define users environment variables.
set tkWinstall(HOME) $env(HOME)
set tkWinstall(USER) [string toupper $env(USER)]
set tkWinstall(IMAGE_DIR) "images"

# Define the bitmap for the icon and its name.
wm iconbitmap . @$tkWinstall(IMAGE_DIR)/tkWorld_icon.xbm
wm iconname . "tkWinstall"

# Define the global image variables.
set tkWinstall(IMAGE_INSTALL) [image create photo \
	-file $tkWinstall(IMAGE_DIR)/tkWinstall_install.gif]
set tkWinstall(IMAGE_UNINSTALL) [image create photo \
	-file $tkWinstall(IMAGE_DIR)/tkWinstall_uninstall.gif]
set tkWinstall(IMAGE_EXIT) [image create photo \
	-file $tkWinstall(IMAGE_DIR)/tkWorld_exit.gif]
set tkWinstall(IMAGE_ICON) [image create photo \
	-file $tkWinstall(IMAGE_DIR)/tkWorld_icon.gif]
set tkWinstall(ANIMATE_ICON) [image create photo \
	-file $tkWinstall(IMAGE_DIR)/tkWorld_icon.gif]
foreach x "1 2 3 4 5 6" {
    set tkWinstall(IMAGE_ANIMATE_$x) [image create photo \
	    -file $tkWinstall(IMAGE_DIR)/tkWinstall_animate_$x.gif]
}

# Determine attributes based on who is running the install script.
if {[string toupper $tkWinstall(USER)] == "ROOT"} {
    set tkWinstall(SOURCE_DIR) \
	    "/usr/local/src/tkWorld-$tkWinstall(DISTRIBUTION)"
    set tkWinstall(BIN_DIR) "/usr/local/bin"
    set tkWinstall(USER_MODE) "Root Mode"
} else {
    set tkWinstall(SOURCE_DIR) [exec pwd]
    set tkWinstall(BIN_DIR) "$env(HOME)/bin"
    set tkWinstall(USER_MODE) "Single User Mode"
}

# Determine the path for the Bourne Shell.
regsub -all {\\n} [exec which sh] {} tkWinstall(SH_PATH)

# Define the entry color variables.
set tkWinstall(ENTRY_DEFAULT_FOREGROUND) #000000
set tkWinstall(ENTRY_DEFAULT_BACKGROUND) #ffffff
set tkWinstall(ENTRY_ERROR_FOREGROUND) #000000
set tkWinstall(ENTRY_ERROR_BACKGROUND) #fffff7098f9d