#
# Name
#
#   update_index.tcl
#
# Description
#
#   Contains a procedure to update the tclIndex file.
#
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

proc LibraryUpdateIndex { p_dir } {
    # Initialize to not update the tclIndex file.
    set p_update 0

    # If the file does not exists, create it.  Otherwise check the
    #   directory and its .tcl contents if they are newer than the
    #   tclIndex file.  
    if ![file exists $p_dir/tclIndex] {
	set p_update 1
    } else {
	set p_index_age [file mtime $p_dir/tclIndex]
	set p_update 0
	# Changes to directory may mean files were deleted/added.
	if {[file mtime $p_dir] > $p_index_age} {
	    set p_update 1
	} else {
	    # Check each file for modification.
	    foreach p_file [glob $p_dir/*.tcl] {
		if {[file mtime $p_file] > $p_index_age} {
		    set p_update 1
		    break
		}
	    }
	}
    }

    # Rebuild the tclIndex file.
    if $p_update {
	auto_mkindex $p_dir *.tcl
    }
}

