/* 
 * tixGrData.c --
 *
 *	This module manipulates the data structure for a Grid widget.
 *
 * Copyright (c) 1996, Expert Interface Technologies
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <tkInt.h>
#include <tixInt.h>
#include <tixGrid.h>

/* potential proble with wrap-around */
static int GetUniqueIndex()
{
    static int uniq = 0;

    return uniq++;
}

static TixGridRowCol * InitRowCol(index)
    int index;
{
    TixGridRowCol * rowCol = (TixGridRowCol *)ckalloc(sizeof(TixGridRowCol));

    rowCol->dispIndex      = index;
    rowCol->size.sizeType  = TIX_GR_DEFAULT;
    rowCol->size.sizeValue = 0;
    rowCol->size.charValue = 0;
    rowCol->size.pad0      = 2;
    rowCol->size.pad1      = 2;
    rowCol->size.pixels    = 0;

    Tcl_InitHashTable(&rowCol->list, TCL_ONE_WORD_KEYS);

    return rowCol;
}


TixGridDataSet*	TixGridDataSetInit()
{
    TixGridDataSet * dataSet =(TixGridDataSet*)ckalloc(sizeof(TixGridDataSet));

    Tcl_InitHashTable(&dataSet->index[0], TCL_ONE_WORD_KEYS);
    Tcl_InitHashTable(&dataSet->index[1], TCL_ONE_WORD_KEYS);

    return dataSet;
}

ClientData TixGridDataFindEntry(dataSet, x, y)
    TixGridDataSet * dataSet;
    int x;
    int y;
{
    TixGridRowCol *col, *row;
    Tcl_HashEntry *hashPtr;

    /* (1) Find the row and column */
    if (!(hashPtr = Tcl_FindHashEntry(&dataSet->index[0], (char*)x))) {
	return NULL;
    }
    col = (TixGridRowCol *)Tcl_GetHashValue(hashPtr);

    if (!(hashPtr = Tcl_FindHashEntry(&dataSet->index[1], (char*)y))) {
	return NULL;
    }
    row = (TixGridRowCol *)Tcl_GetHashValue(hashPtr);

    /* (2) Find the entry */
    if (row->list.numEntries < col->list.numEntries) {
	if (!(hashPtr = Tcl_FindHashEntry(&row->list, (char*)col))) {
	    return NULL;
	}
    }
    else {
	if (!(hashPtr = Tcl_FindHashEntry(&col->list, (char*)row))) {
	    return NULL;
	}
    }

    return (ClientData)Tcl_GetHashValue(hashPtr);
}

/* find or create the entry at the specified index */
ClientData TixGridDataCreateEntry(dataSet, x, y, defaultEntry)
    TixGridDataSet * dataSet;
    int x;
    int y;
    ClientData defaultEntry;
{
    TixGridRowCol *rowcol[2];
    Tcl_HashEntry *hashPtr;
    int isNew, i, dispIndex[2];

    dispIndex[0] = x;
    dispIndex[1] = y;

    for (i=0; i<2; i++) {
	hashPtr = Tcl_CreateHashEntry(&dataSet->index[i],
	    (char*)dispIndex[i], &isNew);

	if (!isNew) {
	    rowcol[i] = (TixGridRowCol *)Tcl_GetHashValue(hashPtr);
	} else {
	    rowcol[i] = InitRowCol(dispIndex[i]);
	    Tcl_SetHashValue(hashPtr, (char*)rowcol[i]);
	}
    }

    hashPtr = Tcl_CreateHashEntry(&rowcol[0]->list,
	(char*)rowcol[1], &isNew);

    if (!isNew) {
	return (ClientData) Tcl_GetHashValue(hashPtr);
    }
    else {
	Tcl_SetHashValue(hashPtr, (char*)defaultEntry);

	hashPtr = Tcl_CreateHashEntry(&rowcol[1]->list,
	    (char*)rowcol[0], &isNew);
	Tcl_SetHashValue(hashPtr, (char*)defaultEntry);

	return defaultEntry;
    }
}

void Tix_GridDataInsert(dataSet, x, y, defaultEntry)
    TixGridDataSet * dataSet;
    int x;
    int y;
    ClientData defaultEntry;
{
    /* ?? %% potential memory leak */

}

static int RowColMaxSize(wPtr, which, rowCol, defSize)
    WidgetPtr wPtr;
    int which;				/* 0=cols, 1=rows */
    TixGridRowCol *rowCol;
    TixGridSize * defSize;
{
    Tcl_HashSearch hashSearch;
    Tcl_HashEntry *hashPtr;
    TixGrEntry * chPtr;
    int maxSize = 1;

    if (rowCol->list.numEntries == 0) {
	return defSize->pixels;
    }

    for (hashPtr = Tcl_FirstHashEntry(&rowCol->list, &hashSearch);
	 hashPtr;
	 hashPtr = Tcl_NextHashEntry(&hashSearch)) {

	chPtr = (TixGrEntry *)Tcl_GetHashValue(hashPtr);
	if (maxSize < chPtr->iPtr->base.size[which]) {
	    maxSize = chPtr->iPtr->base.size[which];
	}
    }

    return maxSize;
}

/* width of column or height of rows */
int Tix_GridDataGetRowColSize(wPtr, dataSet, which, index, defSize, pad0, pad1)
    WidgetPtr wPtr;
    TixGridDataSet * dataSet;
    int which;				/* 0=cols, 1=rows */
    int index;
    TixGridSize * defSize;
    int *pad0;
    int *pad1;
{
    TixGridRowCol *rowCol;
    Tcl_HashEntry *hashPtr;
    int size;

    if (!(hashPtr = Tcl_FindHashEntry(&dataSet->index[which], (char*)index))) {
	size  = defSize->pixels;
	*pad0 = defSize->pad0;
	*pad1 = defSize->pad1;
    }
    else {
	rowCol = (TixGridRowCol *)Tcl_GetHashValue(hashPtr);
    
	switch (rowCol->size.sizeType) {
	  case TIX_GR_AUTO:
	    size  = RowColMaxSize(wPtr, which, rowCol, defSize);
	    *pad0 = rowCol->size.pad0;
	    *pad1 = rowCol->size.pad1;
	    break;

	  case TIX_GR_DEFINED_PIXEL:
	    size  = rowCol->size.sizeValue;
	    *pad0 = rowCol->size.pad0;
	    *pad1 = rowCol->size.pad1;
	    break;

	  case TIX_GR_DEFINED_CHAR:
	    size  = rowCol->size.charValue * wPtr->fontSize[which];
	    *pad0 = rowCol->size.pad0;
	    *pad1 = rowCol->size.pad1;
	    break;

	  case TIX_GR_DEFAULT:
	  default:			/* some error ?? */
	    if (defSize->sizeType == TIX_GR_AUTO) {
		size = RowColMaxSize(wPtr, which, rowCol, defSize);
	    } else {
		size = defSize->pixels;
	    }
	    *pad0 = defSize->pad0;
	    *pad1 = defSize->pad1;
	}
    }

    return size;
}

/* configure width of column or height of rows */
int
Tix_GridDataConfigRowColSize(interp, wPtr, dataSet, which, index, argc, argv,
	argcErrorMsg, changed_ret)
    Tcl_Interp * interp;
    WidgetPtr wPtr;
    TixGridDataSet * dataSet;
    int which;				/* 0=cols, 1=rows */
    int index;
    int argc;
    char ** argv;
    char * argcErrorMsg;
    int *changed_ret;
{
    TixGridRowCol *rowCol;
    Tcl_HashEntry *hashPtr;
    int isNew, code;

    hashPtr = Tcl_CreateHashEntry(&dataSet->index[which],(char*)index, &isNew);

    if (!isNew) {
	rowCol = (TixGridRowCol *)Tcl_GetHashValue(hashPtr);
    } else {
	rowCol = InitRowCol(index);
	Tcl_SetHashValue(hashPtr, (char*)rowCol);
    }

    code = Tix_GrConfigSize(interp, wPtr, argc, argv, &rowCol->size,
	argcErrorMsg, changed_ret);

    if (changed_ret) {
	*changed_ret != isNew;
    }
}


int Tix_GridDataGetGridSize(dataSet, width_ret, height_ret)
    TixGridDataSet * dataSet;
    int *width_ret;
    int *height_ret;
{
    int maxSize[2], i;
    Tcl_HashEntry *hashPtr;
    Tcl_HashSearch hashSearch;
    TixGridRowCol * rowCol;

    if (dataSet->index[0].numEntries == 0 || dataSet->index[1].numEntries==0) {
	*width_ret  = 1;
	*height_ret = 1;
	return;
    }

    maxSize[0] = 1;
    maxSize[1] = 1;

    for (i=0; i<2; i++) {
	
	for (hashPtr = Tcl_FirstHashEntry(&dataSet->index[i], &hashSearch);
	     hashPtr;
	     hashPtr = Tcl_NextHashEntry(&hashSearch)) {

	    rowCol = Tcl_GetHashValue(hashPtr);
	    if (maxSize[i] < rowCol->dispIndex+1) {
		maxSize[i] = rowCol->dispIndex+1;
	    }
	}
    }
    *width_ret  = maxSize[0];
    *height_ret = maxSize[1];
}
