/* 
 * tixGrSel.c --
 *
 *	This module handles the selection
 *
 * Copyright (c) 1996, Expert Interface Technologies
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#include <tkInt.h>
#include <tixInt.h>
#include <tixDef.h>
#include <tixGrid.h>

static TIX_DECLARE_SUBCMD(Tix_GrSelIncludes);
static TIX_DECLARE_SUBCMD(Tix_GrSelModify);

int
Tix_GrSelection(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    static Tix_SubCmdInfo subCmdInfo[] = {
	{TIX_DEFAULT_LEN, "clear",    2, 4, Tix_GrSelModify,
	   "x1 y1 ?x2 y2?"},
	{TIX_DEFAULT_LEN, "includes", 2, 4, Tix_GrSelIncludes,
	   "x1 y1 ?x2 y2?"},
	{TIX_DEFAULT_LEN, "set",      2, 4, Tix_GrSelModify,
	   "x1 y1 ?x2 y2?"},
	{TIX_DEFAULT_LEN, "toggle",   2, 4, Tix_GrSelModify,
	   "x1 y1 ?x2 y2?"},
    };
    static Tix_CmdInfo cmdInfo = {
	Tix_ArraySize(subCmdInfo), 1, TIX_VAR_ARGS, "?option? ?arg ...?",
    };

    return Tix_HandleSubCmds(&cmdInfo, subCmdInfo, clientData,
	interp, argc+1, argv-1);
}

static int
Tix_GrSelIncludes(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;
    return TCL_OK;
}

static int Intersect(s1, s2)
    SelectBlock * s1;
    SelectBlock * s2;
{



}

static int Include(s1, s2)
    SelectBlock * s1;
    SelectBlock * s2;
{



}

static void
Tix_GrMergeSelection(wPtr, sbPtr)
    WidgetPtr wPtr;
    SelectBlock * sbPtr;
{
    Tix_ListIterator li;
    SelectBlock * s2;

#if 1
    Tix_SimpleListAppend(&wPtr->selList, (char*)sbPtr, 0);
#else
    switch (sbPtr->type) {
        case TIX_GR_TOGGLE: {
	}
	break;
	case TIX_GR_SET: {


        }
        break;
        case TIX_GR_CLEAR: {
	    Tix_SimpleListIteratorInit(&li);

	    for (Tix_SimpleListStart(&wPtr->selList, &li);
		 !Tix_SimpleListDone(&li);
		 Tix_SimpleListNext (&wPtr->selList, &li)) {




	    }
        }
        break;
    }
#endif



}



static int
Tix_GrSelModify(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    WidgetPtr wPtr = (WidgetPtr) clientData;
    int type;
    SelectBlock * sbPtr;

    if (argc != 2 && argc != 4) {
	return Tix_ArgcError(interp, argc+2, argv-2, 2, "x1 y1 ?x2 y2?");
    }

    /* (1) find out the type of operation */
    if (argv[-1][0] == 'c') {
	type = TIX_GR_CLEAR;
    }
    else if (argv[-1][0] == 's') {
	type = TIX_GR_SET;
    }
    else {
	type = TIX_GR_TOGGLE;
    }

    sbPtr = (SelectBlock*)ckalloc(sizeof(SelectBlock));
    sbPtr->type = type;

    if (Tcl_GetInt(interp, argv[0], &sbPtr->range[0][0]) != TCL_OK) {
	goto error;
    }
    if (Tcl_GetInt(interp, argv[1], &sbPtr->range[1][0]) != TCL_OK) {
	goto error;
    }
    if (argc == 4) {
	if (Tcl_GetInt(interp, argv[2], &sbPtr->range[0][1]) != TCL_OK) {
	    if (strcmp(argv[2], "max") == 0) {
		Tcl_ResetResult(interp);
		sbPtr->range[0][1] = TIX_GR_MAX;
	    } else {
		goto error;
	    }
	}
	if (Tcl_GetInt(interp, argv[3], &sbPtr->range[1][1]) != TCL_OK) {
	    if (strcmp(argv[3], "max") == 0) {
		Tcl_ResetResult(interp);
		sbPtr->range[1][1] = TIX_GR_MAX;
	    } else {
		goto error;
	    }
	}
    } else {
	sbPtr->range[0][1] = sbPtr->range[0][0];
	sbPtr->range[1][1] = sbPtr->range[1][0];
    }

    Tix_GrMergeSelection(wPtr, sbPtr);
    Tix_GrDoWhenIdle(wPtr, TIX_GR_COMPUTE_SEL);
    return TCL_OK;
  error:
    ckfree((char*)sbPtr);
    return TCL_ERROR;
}
