/*
 * tixGData.h --
 *
 *	Defines portable data structure for tixGrid
 *
 * Copyright (c) 1996, Expert Interface Technologies
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

#ifndef _TIX_GRID_DATA_H_
#define _TIX_GRID_DATA_H_

/* type name exported */
typedef struct TixGridDataSet {
    Tcl_HashTable index[2];		/* the row and column indices */
    					/* index[0] holds the columns 
					 * (horizontal index)
					 */
} TixGridDataSet;

#define TIX_GR_AUTO			0
#define TIX_GR_DEFAULT			1
#define TIX_GR_DEFINED_PIXEL		2
#define TIX_GR_DEFINED_CHAR		3

typedef struct TixGridSize {
    int sizeType;
    int sizeValue;			/* width or height */
    int pixels;
    int pad0, pad1;
    double charValue;
} TixGridSize;

typedef struct TixGridRowCol {
/* private: */
    Tcl_HashTable list;

/* public: */
    int dispIndex;			/* the row or column in which
					 * this TixGridRowCol is displayed */
    TixGridSize size;
} TixGridRowCol;

#endif
