# SGrid.tcl --
#
#	This file implements Scrolled Grid widgets
#
# Copyright (c) 1996, Expert Interface Technologies
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

tixWidgetClass tixScrolledGrid {
    -classname TixScrolledGrid
    -superclass tixScrolledWidget
    -method {
    }
    -flag {
    }
    -configspec {
    }
    -default {
	{.scrollbar			auto}
	{*grid.borderWidth		1}
	{*grid.Background		#c3c3c3}
	{*grid.highlightBackground	#d9d9d9}
	{*grid.relief			sunken}
	{*grid.takeFocus		1}
	{*Scrollbar.background		#d9d9d9}
	{*Scrollbar.troughColor		#c3c3c3}
	{*Scrollbar.takeFocus		0}
	{*Scrollbar.relief		sunken}
	{*Scrollbar.width		15}
    }
}

proc tixScrolledGrid::ConstructWidget {w} {
    upvar #0 $w data

    tixChainMethod $w ConstructWidget

    set data(w:grid) [tixGrid $w.grid]

    pack $data(w:grid) -expand yes -fill both -padx 0 -pady 0

    set data(w:hsb) \
	[scrollbar $w.hsb -orient horizontal -takefocus 0]
    set data(w:vsb) \
	[scrollbar $w.vsb -orient vertical -takefocus 0]
    
    set data(pw:client) $data(w:grid)
}

proc tixScrolledGrid::SetBindings {w} {
    upvar #0 $w data

    tixChainMethod $w SetBindings

    $data(w:grid) config \
	-xscrollcommand "$data(w:hsb) set"\
	-yscrollcommand "$data(w:vsb) set"\
	-sizecmd "tixScrolledWidget::Configure $w"

    $data(w:hsb) config -command "$data(w:grid) xview"
    $data(w:vsb) config -command "$data(w:grid) yview"

}

#----------------------------------------------------------------------
#
#		option configs
#----------------------------------------------------------------------
proc tixScrolledGrid::config-takefocus {w value} {
    upvar #0 $w data
  
    $data(w:grid) config -takefocus $value
}	

#----------------------------------------------------------------------
#
#		Widget commands
#----------------------------------------------------------------------


#----------------------------------------------------------------------
#
#		Private Methods
#----------------------------------------------------------------------

#----------------------------------------------------------------------
# virtual functions to query the client window's scroll requirement
#----------------------------------------------------------------------
proc tixScrolledGrid::GeometryInfo {w mW mH} {
    upvar #0 $w data


    if {$mW < 1} {
	set mW 1
    }
    if {$mH < 1} {
	set mH 1
    }

    return [$data(w:grid) geometryinfo $mW $mH]
}
