#
# AddComment: adds a comment to the presentation.
#
proc AddComment {} {
    global ReplayData
    set w .replay.commentSpecify
    if [winfo exists $w] {
        catch "$w.text delete 1.0 end"
        wm deiconify $w
    } else {
        toplevel $w
        wm geometry $w "+0+0"
        label $w.label -relief raised -bd 2 \
            -text "Enter the text of the comment and press Done"
        pack $w.label -side top -fill x
        text $w.text -width 60 -height 8 -relief sunken -bd 2
        pack $w.text -side top
        checkbutton $w.wait -text "Wait for user to check Okay" \
            -variable ReplayData(WaitForOkay)
        $w.wait deselect
        pack $w.wait -side top -fill x
        frame $w.delay
        pack $w.delay -side top -fill x
        label $w.delay.label -text "Delay (in 10th/second):" \
            -relief raised -bd 2
        pack $w.delay.label -side left
        entry $w.delay.value -relief sunken -bd 2
        pack $w.delay.value -side top -fill x -expand yes
        frame $w.buttons
        pack  $w.buttons -side top -fill x
        button $w.buttons.done -text Done -width 12 \
            -command "set ReplayData(DoneVar) 1"
        pack $w.buttons.done -side left -fill x -expand yes
        button $w.buttons.cancel -text Cancel -width 12 \
            -command "set ReplayData(DoneVar) 0"
        pack $w.buttons.cancel -side left -fill x -expand yes
    }
    # turn off recording while writing the comment
    set ReplayData(recordingOn) 0
    focus $w.text
    set ReplayData(DoneVar) 2
    tkwait variable ReplayData(DoneVar)
    if {$ReplayData(DoneVar) == 0} {
        wm withdraw $w
        MakeComment 0 "Comment cancelled"
        return
    }
    set comment [$w.text get 1.0 end]
    wm withdraw $w
    set delay [$w.delay.value get]
    if {$delay == ""} {
         set delay 0
    }
    if $ReplayData(WaitForOkay) {
        set delay -1
    }
    InsertAction $delay Comment $comment
    # turn on recording and restart the timer
    set ReplayData(recordingOn) 1
    ReplayTimerTick
}
#
# MakeComment: displays a comment on the screen.
#
proc MakeComment {delay comment} {
    global ReplayData
    .replay.message configure -text $comment
    update idletasks
    if {$delay >= 0} {
        after $delay
    } else {
        set w .replay.commentWindow
        if [winfo exists $w] {
            wm deiconify $w
        } else {
            toplevel $w
            wm geometry $w "+0+0"
            message $w.msg -aspect 300 -relief raised -bd 2
            pack $w.msg -side top
            button $w.okay -text Okay -command "set ReplayData(DoneVar) 1"
            pack $w.okay -side top
        }
        $w.msg configure -text $comment
        set ReplayData(DoneVar) 0
        tkwait variable ReplayData(DoneVar)
        wm withdraw $w
    }
}










