#
# GetReplayPointer: creates or deiconifies the big pointer we use to
#     point out the widget where the event is happening.
#
proc GetReplayPointer {} {
    set w .replaypointer
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm geometry $w "+0+0"
        wm transient $w
        canvas $w.canvas -width 50 -height 50 -background white
        $w.canvas create line 0 25 50 25 -width 20 -arrow last \
            -fill red -arrowshape {25 40 15}
        pack $w.canvas
    }
}
#
# ReplayActions: this procedure is passed "actions" which is the script
#     of events that we recorded.  It goes through the actions one by
#     one and replays them.
#
proc ReplayActions {actions} {
    global ReplayData
    if {$ReplayData(pointWithArrow)} {GetReplayPointer}
    set actionIndex -1
    foreach f $actions {
        if !$ReplayData(playingOn) {
            break
        }
        incr actionIndex
        if $ReplayData(showEventsPlaying) {
            foreach list {times subs reps} {
                .replay.events.$list yview $actionIndex
                .replay.events.$list select from $actionIndex
            }
        }
        set delay [lindex $f 0]
        if {$delay >= 0} {
            if $ReplayData(UseDelays) {
                after [expr 100*$delay]
            }
        }
        set subscript [lindex $f 1]
        set replaceList [lindex $f 2]
        if {[string compare $subscript "Comment"] == 0 } {
            MakeComment $delay $replaceList
            continue
        }
        if ![info exists ReplayData($subscript)] {
            MakeComment -1 "\
ERROR: ReplayData($subscript) does not exist.
   It may be the widget configuration is different now from when you
   recorded this script."
            continue
        }
        set action $ReplayData($subscript)
        regexp {([^,]*),([^,]*),(.*)} $subscript junk what which event
        set pointToWidget 1
        switch $event \
            "<FocusIn>"   - \
            "<FocusOut>" {
                set pointToWidget 0
            }
        if {!$ReplayData(showEnterEvents)} {
            switch $event \
                "<Any-Enter>" - \
                "<Any-Leave>" {
                    set pointToWidget 0
                }
        }
        set w [lookup W $replaceList]
        if {[SendToApp "winfo exists $w"] == 0} {
            puts \
            "ERROR: $w does not exist. subscript=$subscript action=<$action>"
            continue
        }
        if {$ReplayData(movePointer)} {
            set x [lookup x $replaceList]
            if {$x == ""} {
                 set x 5
            }
            set y [lookup y $replaceList]
            if {$y == ""} {
                 set y 5
            }
            set wid [SendToApp "winfo id $w"]
            catch "WarpPointer . $x $y $wid"
        }
        if {$ReplayData(pointWithArrow) && $pointToWidget} {
            set x [expr $rootx-56]; if {$x<0} {set x 0}
            set y [expr $rooty-25]; if {$y<0} {set y 0}
            wm geometry .replaypointer "+$x+$y"
            raise .replaypointer
            update
        }
        if {$ReplayData(flashWidget) && $pointToWidget} {
            Flash $w
        }
        update
        ReplayAction $action $replaceList
        update
    }
    if {$ReplayData(pointWithArrow)} {
        wm withdraw .replaypointer
    }
}
#
# Flash: flash a widget.
#
proc Flash {w} {
    switch [winfo class $w] \
    "Button" - \
    "Checkbutton" - \
    "RadioButton" {
        $w flash
    } \
    default {
        # some widgets to not have a foreground color
        if [catch {set fg [lindex [$w configure -foreground] 4]}] {
            set fg black
        }
        set bg [lindex [$w configure -background] 4]
        $w configure -background $fg
        catch "$w configure -foreground $bg"
        update
        after 50
        $w configure -background $bg
        catch "$w configure -foreground $fg"
        update
    }
}
#
# RecordControl: the main control procedure for controlling the recording
#     and replaying of events.  "cmd" is the command to execute.
#
proc RecordControl {cmd} {
    global ReplayData
    switch $cmd \
        start {
            #
            # start the recording.  Erase any old recording.  Reset the
            # timer to 0
            #
            if {!$ReplayData(ConnectedToApp)} {
                MakeComment -1 "You cannot record a script  until you \
are connected to an application"
                return
            }
            RecordControl erase
            MakeComment 0 "Start recording a script"
            set ReplayData(recordingOn) 1
            set ReplayData(LastEventAt) 0
            set ReplayData(Timer) 0
            ReplayTimerTick
        } \
        stop {
            #
            # stop recording or playing
            #
            MakeComment 0 "Stop recording a script"
            set ReplayData(recordingOn) 0
            set ReplayData(playingOn) 0
            # turn off the timer
            set ReplayData(Timer) -1
        } \
        replay {
            #
            # replay the actions that were recorded
            #
            if {!$ReplayData(ConnectedToApp)} {
                MakeComment -1 "You cannot replay a script  until you \
are connected to an application"
                return
            }
            MakeComment 0 "Start replaying the script"
            set ReplayData(playingOn) 1
            set ReplayData(UseDelays) 1
            ReplayActions $ReplayData(script)
            set ReplayData(playingOn) 0
            MakeComment 0 "Finished replaying the script"
        } \
        replayFast {
            #
            # replay the actions that were recorded (with no delays)
            #
            if {!$ReplayData(ConnectedToApp)} {
                MakeComment -1 "You cannot replay a script  until you \
are connected to an application"
                return
            }
            MakeComment 0 "Start replaying a script (no delays)"
            set ReplayData(playingOn) 1
            set ReplayData(UseDelays) 0
            ReplayActions $ReplayData(script)
            set ReplayData(playingOn) 0
            MakeComment 0 "Finished replaying the script"
        } \
        erase {
            #
            # erase the recorded actions
            #
            MakeComment 0 "Erase the current script"
            set ReplayData(script) {}
            foreach list {times subs reps} {
                .replay.events.$list delete 0 end
            }
        } \
        save {
            #
            # save the script of recorded actions
            #
            MakeComment 0 "Select a name to save the script to"
            set filename [FSBox "Select a name to save the script to"]
            if {$filename == ""} {
                MakeComment 0 "Save cancelled"
                return
            }
            set fid [open $filename w]
            puts $fid "global ReplayData"
            puts $fid "set ReplayData(script) {"
            foreach event $ReplayData(script) {
                puts $fid [format "{%s}" $event]
            }
            puts $fid "}"
            close $fid
            MakeComment 0 "Saved script to \"$filename\""
        } \
        load {
            #
            # load a previously recorded script
            #
            MakeComment 0 "Select a file to load the script from"
            set filename [FSBox "Select a file to load the script from"]
            if {$filename == ""} {
                MakeComment 0 "Load cancelled"
                return
            }
            RecordControl erase
            source $filename
            foreach event $ReplayData(script) {
                InsertAction [lindex $event 0] [lindex $event 1] \
                    [lindex $event 2] 0
            }
            MakeComment 0 "Loaded script from \"$filename\""
        }
}






