#include "tk.h"

int
WarpPointer( clientData, interp, argc, argv )
    ClientData clientData;
    Tcl_Interp * interp;
    int argc;
    char **argv;
{
    int x, y;
    Tk_Window tkwin;
    Window wid;

    if (argc < 4) {
        sprintf(interp->result,
            "wrong # args: should be warpPointer widget x y");
        return TCL_ERROR;
    }

    if ((Tcl_GetInt(interp, argv[2], &x) == TCL_ERROR) ||
	(Tcl_GetInt(interp, argv[3], &y) == TCL_ERROR))
	return TCL_ERROR;
    
    tkwin = Tk_MainWindow(interp);
    if( tkwin == NULL ) {
       sprintf(interp->result, "Could not find main window of application");
	return TCL_ERROR;
    }
    
    tkwin = Tk_NameToWindow(interp, argv[1], tkwin);
    if( tkwin == NULL ) {
       sprintf(interp->result, "Could not find window %s", argv[1]);
	return TCL_ERROR;
    }

    sscanf( argv[4], "0x%x", &wid );
    XWarpPointer(Tk_Display(tkwin), None, wid, 0, 0, 0, 0, x, y);
/***** Old way
    XWarpPointer(Tk_Display(tkwin), None, None, 0, 0, 0, 0, x, y);
*****/
    return TCL_OK;
}







