#
# AddComment: adds a comment to the presentation.
#
proc AddComment {} {
    global ReplayData
    if {$ReplayData(RecordingOn) == 0} {
        MsgToUser "Comments can only be added while recording a script" low
        return
    }
    set commentNumber [info cmdcount]
    set w .replay.addComment
    toplevel $w
    wm geometry $w "+0+0"
    message $w.label -relief raised -bd 2 -width 550 -text "\
        The comment will appear at this point in the replay.\
        Enter the text you want in the comment now and press Text Done.\
        The comment will stay visible (during replay) until after the
        event where you Dismiss this comment box."
    pack $w.label -side top -fill x
    text $w.text -width 60 -height 8 -relief sunken -bd 2 -bg snow
    pack $w.text -side top
    checkbutton $w.wait -text "Wait for user to check Okay" \
        -variable ReplayData(WaitForOkay)
    $w.wait deselect
    pack $w.wait -side top -fill x
    frame $w.buttons -bd 2 -relief raised
    pack  $w.buttons -side top -fill x -ipadx 5 -ipady 5
    button $w.buttons.done -text "Text Done" \
        -command "set ReplayData(DoneVar) 1"
    pack $w.buttons.done -side left -fill x
    button $w.buttons.dismiss -text "Dismiss Comment" \
        -command "EndComment $w $commentNumber" \
        -state disabled
    pack $w.buttons.dismiss -side left -fill x
    button $w.buttons.cancel -text "Cancel" \
        -command "set ReplayData(DoneVar) 0"
    pack $w.buttons.cancel -side left -fill x
    #
    # turn off recording while writing the comment
    #
    set ReplayData(RecordingOn) 0
    focus $w.text
    set ReplayData(DoneVar) 2
    tkwait variable ReplayData(DoneVar)
    $w.label configure -text "\
        The comment text is now set.  When you get the the point in\
        the script where you want the comment to go away, press Dismiss."
    set comment [$w.text get 1.0 end]
    $w.text configure -state disabled
    $w.buttons.done configure -state disabled
    $w.buttons.cancel configure -state disabled
    $w.buttons.dismiss configure -state normal
    InsertAction 0 ThisApp BeginComment \
        [list $comment $ReplayData(WaitForOkay) $commentNumber]
    # turn on recording and restart the timer
    set ReplayData(RecordingOn) 1
    ReplayTimerTick
}
proc EndComment {w commentNumber} {
    InsertAction 0 ThisApp EndComment $commentNumber
    destroy $w
}
#
# MakeComment: displays a comment on the screen.
#
proc MakeComment {comment wait {id -1}} {
    global ReplayData
    if {$id == -1} {
        set id [GetUniqueID]
    }
    set w [format {.comment%s} $id]
    toplevel $w
    wm title $w "Comment"
    wm geometry $w "+0+0"
    message $w.msg -aspect 400 -relief raised -bd 2 -text $comment -bg snow
    pack $w.msg -side top
    if $wait {
        button $w.okay -text "Okay" -command "set ReplayData(DoneVar) 1"
        pack $w.okay -side top
        set ReplayData(DoneVar) 0
        update
        tkwait variable ReplayData(DoneVar)
        destroy $w
    }
    update
}
#
# MsgToUser: displays a message on the screen.
#
proc MsgToUser {comment {level info}} {
    global ReplayData
    RecordMessage $comment
    switch $level \
        info {
            .replay.message configure -text $comment
        } \
        low - \
        medium - \
        high {
            set w [format {.msg%s} [GetUniqueID]]
            toplevel $w
            wm title $w "Message to User"
            wm geometry $w "+0+0"
            message $w.msg -aspect 400 -relief raised -bd 2 -text $comment
            pack $w.msg -side top -expand yes
            button $w.okay -text "Okay" -command "destroy $w"
            pack $w.okay -side top
        }
    update
}
