###################################################################
# MonitorApps: find the names of all existing interpeters.
#   We also check to be see if any of the interpreters we are
#   connected to have quit.
###################################################################
proc MonitorApps {} {
    global ReplayData
    set ReplayData(ExistingApps) [lsort [winfo interps]]
    #
    # see if any of our connected apps have quit
    #
    set cl {}
    set wasChanged 0
    foreach app $ReplayData(ConnectedApps) {
        if {[lmember $app $ReplayData(ExistingApps)]} {
            lappend cl $app
        } else {
            MsgToUser "Connected application \"$app\" has exited." low
            set wasChanged 1
        }
    }
    if {$wasChanged} {
        set ReplayData(ConnectedApps) [lsort $cl]
        if {$cl == {}} {
            set list "<None>"
        } else {
            set list  $ReplayData(ConnectedApps)
        }
        .replay.connected configure -text "Currently connected to: $list"
    }
    after 3000 MonitorApps
}
###################################################################
# FillConnectMenu: get the app name from the list bax and connect to the app.
###################################################################
proc FillConnectMenu {menu} {
    global ReplayData
    $menu delete 0 last
    foreach interp [lsort [winfo interps]] {
        $menu add command -label $interp -command "ConnectToApp $interp"
    }
}
###################################################################
# ConnectToApp: connect to the app.
###################################################################
proc ConnectToApp {app} {
    global ReplayData
    if {[lmember $app $ReplayData(ConnectedApps)]} {
        MsgToUser "Already connected to \"$app\"" low
        return
    }
    MsgToUser "Connecting to \"$app\". Please wait ..."
    SendToApp $app [format {
        global db__rd
        set db__rd(ReplayApp) %s
        set db__rd(ThisApp) [winfo name .]
        set db__rd(UIDCounter)      0
        set db__rd(ActionTimeOut)   8000} \
        $ReplayData(ThisApp)]
    SendToApp $app [list source $ReplayData(HomeDirectory)/rebind.tcl]
    if {$ReplayData(RecordingOn)} {
        InsertAction 0 ThisApp ConnectToApp $app
    }
    MsgToUser "Connected to \"$app\" recording or replaying"
    .replay.connected configure -text \
        "Currently connected to: [lsort $ReplayData(ConnectedApps)]"
    lappend ReplayData(ConnectedApps) $app
}
###################################################################
# SendToApp: send to the application (and get reply).
###################################################################
proc SendToApp {app cmd} {
    global ReplayData
     set err [catch [list send $app $cmd] ret]
    if $err {
        if {[lmember $app $ReplayData(ConnectedApps)]} {
            MsgToUser "Send to $app ($cmd) failed: $ret" medium
        } else {
            MsgToUser "Send failed: not connected to $app" low
        }
        return ""
    } else {
        return $ret
    }
}
###################################################################
# QuitReplay: exit the program.
###################################################################
proc QuitReplay {} {
    exit
}
