###################################################################
# lmember: a utility procedure that determines if a string is a
#    member of a list.  Useful when we are using lists as sets.
###################################################################
proc lmember {item list} {
    if {[lsearch -exact $list $item] >= 0} {
        return 1
    } else {
        return 0
    }
}
###################################################################
# FSBox: Create a file selection box.
###################################################################
proc FSBox {msg} {
    global ReplayData
    set w .fsbox
    if [winfo exists $w] {
        $w.fileName delete 0 end
        wm deiconify $w
    } else {
	toplevel $w
	wm title $w "File Selection"
	label $w.title -text $msg
	pack $w.title -side top
	frame $w.fileList
	pack $w.fileList -side top -fill both -expand yes
	scrollbar $w.fileList.yscroll -orient vertical \
	    -command "$w.fileList.listbox yview"
	pack $w.fileList.yscroll -side left -fill y
	listbox $w.fileList.listbox -width 30 -height 10 \
	    -yscroll " $w.fileList.yscroll set"
	pack $w.fileList.listbox -side left -fill both -expand yes
	bindtags $w.fileList.listbox [list Listbox $w.fileList.listbox . all]
	bind $w.fileList.listbox <1> \
	    "ListSelect $w.fileList.listbox $w.fileName"
	bind $w.fileList.listbox <Double-1> "set ReplayData(UserReply) 1"
	entry $w.fileName -bd 2 -relief sunken
	pack $w.fileName -side top
	bind $w.fileName <Return> "set ReplayData(UserReply) 1"
	frame $w.buttons -bd 2 -relief sunken
	pack $w.buttons -side top -padx 5 -pady 5
	button $w.buttons.okay -text "Okay" \
	    -command "set ReplayData(UserReply) 1"
	pack $w.buttons.okay -side left
	button $w.buttons.cancel -text "Cancel" \
	    -command "set ReplayData(UserReply) 0"
	pack $w.buttons.cancel -side left
    }
    FillFSBox  $w.fileList.listbox
    set ReplayData(UserReply) 0
    tkwait variable ReplayData(UserReply)
    if {$ReplayData(UserReply)} {
        set fileName [$w.fileName get]
    } else {
        set fileName ""
    }
    wm withdraw $w
    return $fileName
}
proc ListSelect {listbox entry} {
    $entry delete 0 end
    $entry insert end [$listbox get [$listbox curselect]]
}
proc FillFSBox {listbox} {
    $listbox delete 0 end
    set files [lsort [glob *]]
    eval $listbox insert end [linsert $files 0 ".."]
}
