#
# AboutBox: create the about box
#
proc AboutBox {} {
    global ReplayData
    set w .aboutBox
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm title $w "About TkReplay"
        message $w.msg -aspect 500 -text "\
     TkReplay - record and replay for Tcl/Tk
        Version $ReplayData(Version) of $ReplayData(Date)

        Charlie Crowley
        Computer Science Department
        Univ. Of New Mexico
        crowley@cs.unm.edu
        http://www.cs.unm.edu/~crowley/

Click in box to dismiss.
"
        pack $w.msg
        bind $w.msg <1> "wm withdraw $w"
    }
}
#
# RecordMessage: record a message in the transcript window
#
proc RecordMessage {msg} {
    .messageWindow.text insert end $msg
    .messageWindow.text insert end \n
    .messageWindow.text yview -pickplace end
}
#
# MakeMessageWindow: create a window to record messages
#
proc MakeMessageWindow {} {
    set w .messageWindow
    toplevel $w
    wm geometry $w "+0+260"
    wm withdraw $w
    button $w.done -text "Hide this window" -command "wm withdraw $w"
    pack $w.done -side bottom
    scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
        -command "$w.text yview"
    pack $w.yscroll -side right -fill y
    text $w.text -width 50 -height 16 -relief sunken -bd 2 \
        -yscrollcommand "$w.yscroll set"
    pack $w.text -side left -fill both -expand yes
    $w.text insert end "*** Transcript of all message ***\n"
}
#
# ShowHelp: display a text window on the help text
#
proc ShowHelp {} {
    global ReplayData
    set w .replay.helpWindow
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm minsize $w 10 10
        wm geometry $w "+0+0"
        button $w.done -text Done -command "wm withdraw $w"
        pack $w.done -side bottom
        scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
            -command "$w.text yview"
        pack $w.yscroll -side right -fill y
        text $w.text -width 80 -height 30 -relief sunken -bd 2 \
            -yscrollcommand "$w.yscroll set"
        pack $w.text -side left -fill both -expand yes
        $w.text insert end $ReplayData(HelpText)
    }
}
proc CreateHelpFile {} {
    global ReplayData
    if [catch "open $ReplayData(HomeDirectory)/HelpFile" fid] {
        error \
            "Could not open help file \"$ReplayData(HomeDirectory)/HelpFile\""
    }
    set ReplayData(HelpText) [read $fid]
    close $fid
}
