###################################################################
# Initialize: initializes the global variables.
###################################################################
proc Initialize {} {
    global ReplayData
    #
    CreateHelpFile
    #
    # set up global replay data
    #
    set ReplayData(Version)        "1.0b1"
    set ReplayData(Date)           "22 June 1995"
    set ReplayData(PendingCommandUID) 0
    set ReplayData(UIDCounter)     1
    set ReplayData(RecordingOn)    0
    set ReplayData(PlayingOn)      0
    set ReplayData(ConnectedApps)  {}
    set ReplayData(Script)         {}
    set ReplayData(ScriptIndex)    0
    set ReplayData(ThisApp)        [winfo name .]
    set ReplayData(ScriptFileName) "Unnamed"
    #
    # initialize various option settings
    #
    set ReplayData(pointWithArrow)      0
    set ReplayData(movePointer)         1
    set ReplayData(MouseSpeed)          3
    set ReplayData(showFocusEvents)     0
    set ReplayData(showEnterEvents)     1
    set ReplayData(showEventsRecording) 1
    set ReplayData(showEventsPlaying)   1
    #
    # check for the WarpPointer command
    #
    if {[catch "WarpPointer 1 1 0"]} {
        puts "NOTE: cannot move the mouse pointer so it will not be\
            moved during replay."
        set ReplayData(HasWarpPointer) 0
    } else {
        set ReplayData(HasWarpPointer) 1
    }
}
