###################################################################
# MakeReplayWindow: creates the replay control window.
###################################################################
proc MakeReplayWindow {} {
    global ReplayData
    #
    # create the replay control window
    #
    set w .replay
    set ReplayData(MainWindow) $w
    toplevel $w
    wm title $w "TkReplay"
    label $w.title -text "Tk Record and Replay" \
        -relief raised -bd 2 \
        -font "-Adobe-Helvetica-Bold-o-Normal--*-180-*-*-*-*-*-*"
    pack $w.title -side top
    #
    # a message box
    #
    message $w.message -relief ridge -bd 2 -width 600 -anchor w
    pack $w.message -side top -fill x
    #
    #             Create the replay menus
    #
    set width 8
    frame $w.menu -relief ridge -borderwidth 2
    pack $w.menu -side top -fill x
    #
    # File menu
    #
    menubutton $w.menu.file -text "File" -menu $w.menu.file.m \
        -bd 2 -relief raised -width $width
    pack $w.menu.file -side left
    menu $w.menu.file.m
    $w.menu.file.m add command -label "Open..." -command "Load"
    $w.menu.file.m add command -label "Save" -command "Save"
    $w.menu.file.m add command -label "Save as..." -command "SaveAs"
    $w.menu.file.m add separator
    $w.menu.file.m add cascade -label "Connect to application" \
        -menu $w.menu.file.m.connect
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Load application..." \
        -command "MakeLoadAppBox"
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "About TkReplay..." \
        -command "AboutBox"
    menu $w.menu.file.m.connect -tearoff 0 \
        -postcommand "FillConnectMenu $w.menu.file.m.connect"
    # start a daemon process to keep track of existing apps
    MonitorApps
    $w.menu.file.m add separator
    $w.menu.file.m add command -label "Quit Replay" -command "QuitReplay"
    #
    # Edit menu
    #
    menubutton $w.menu.edit -text "Edit" -menu $w.menu.edit.m \
        -bd 2 -relief raised -width $width
    pack $w.menu.edit -side left
    menu $w.menu.edit.m
    $w.menu.edit.m add command -label "Delete event" -command "DeleteEvent"
    $w.menu.edit.m add command -label "Change delay" -command "EditEvent"
    $w.menu.edit.m add command -label "Move event up" -command "MoveEvent -1"
    $w.menu.edit.m add command -label "Move event down" -command "MoveEvent 1"
    $w.menu.edit.m add separator
    $w.menu.edit.m add command -label "Compress motion events" \
        -command "CompressMotionEvents"
    $w.menu.edit.m add command -label "Erase script" -command "EraseScript"
    $w.menu.edit.m add separator
    $w.menu.edit.m add command -label "Preferences..." -command "OptionBox"
    #
    # Recorder menu
    #
    menubutton $w.menu.record -text "Recorder" -menu $w.menu.record.m \
        -bd 2 -relief raised -width $width
    pack $w.menu.record -side left
    menu $w.menu.record.m
    $w.menu.record.m add command -label "Record" -command "StartRecording"
    $w.menu.record.m add command -label "Stop" -command "StopRecording"
    $w.menu.record.m add command -label "Play" -command "Replay"
    $w.menu.record.m add command -label "Play Fast" -command "ReplayFast"
    $w.menu.record.m add command -label "Rewind" -command "Rewind"
    $w.menu.record.m add separator
    $w.menu.record.m add command -label "Add Comment" -command "AddComment"
    $w.menu.record.m add command -label "Add Pause" -command "AddPause"
    #
    # recording light
    #
    checkbutton $w.menu.recordon -text "Recording" \
        -variable ReplayData(RecordingOn)
    pack $w.menu.recordon -side left
    #
    # Help menu
    #
    menubutton $w.menu.help -text "Help" -menu $w.menu.help.m \
        -bd 2 -relief raised -width $width
    pack $w.menu.help -side right
    menu $w.menu.help.m
    $w.menu.help.m add command -label "Show help file" \
        -command "ShowHelp"
    $w.menu.help.m add command -label "Show messages" \
        -command "wm deiconify .messageWindow"
    #
    #             Create the recorder buttons
    #
    set width 8
    frame $w.buttons1 -relief sunken -borderwidth 2
    pack $w.buttons1 -side top -fill x -padx 2 -pady 2
    button $w.buttons1.start -text "Record" -command "StartRecording" \
        -width $width -bd 3
    pack $w.buttons1.start -side left -padx 4 -pady 4
    button $w.buttons1.stop -text "Stop" -command "StopRecording" \
        -width $width -bd 3
    pack $w.buttons1.stop -side left -padx 4 -pady 4
    button $w.buttons1.comment -text "Comment" -command "AddComment" \
        -width $width -bd 3
    pack $w.buttons1.comment -side left -padx 4 -pady 4
    button $w.buttons1.pause -text "Pause" -command "AddPause" \
        -width $width -bd 3
    pack $w.buttons1.pause -side left -padx 4 -pady 4
    #
    frame $w.buttons2 -relief sunken -borderwidth 2
    pack $w.buttons2 -side top -fill x -padx 2 -pady 2
    button $w.buttons2.replay -text "Play" -command "Replay" \
        -width $width -bd 3
    pack $w.buttons2.replay -side left -padx 4 -pady 4
    button $w.buttons2.rewind -text "Rewind" -command "Rewind" \
        -width $width -bd 3
    pack $w.buttons2.rewind -side left -padx 4 -pady 4
    button $w.buttons2.replayFast -text "Play Fast" \
        -command "ReplayFast" -width $width -bd 3
    pack $w.buttons2.replayFast -side left -padx 4 -pady 4
    #
    # a listbox to display the events that are recorded
    #
    frame $w.events -bd 2 -relief ridge
    pack $w.events -side top -fill both -expand yes
    label $w.events.label -bd 2 -relief raised -anchor center -text ""
    SetScriptFileName
    pack $w.events.label -side top -fill x
    scrollbar $w.events.yscroll -orient vertical -relief sunken \
        -bd 2 -command "$w.events.list yview"
    pack $w.events.yscroll -side left -fill y
    listbox $w.events.list -height 10 -relief sunken \
        -borderwidth 2 -yscroll "$w.events.yscroll set" \
        -exportselection false
    pack $w.events.list -side left -fill both -expand yes
    bind $w.events.list <1> {SelectAndSetItem %W %x %y}
    #
    # list of currently connect apps
    #
    label $w.connected -text "Currently connected to: <None>"
    pack $w.connected -side top
}
proc SetScriptFileName {} {
    global ReplayData
    .replay.events.label configure \
        -text [format "Script file: %s" $ReplayData(ScriptFileName)]
}