#
# OptionBox: allow the user to set various replay options.
#
proc OptionBox {} {
    global ReplayData
    set w .replay.optionBox
    if [winfo exists $w] {
        wm deiconify $w
        raise $w
    } else {
        #
        # make the toplevel and the title
        #
        toplevel $w
        label $w.title -text "Replay Options"
        pack $w.title -side top -fill x
        #
        # make a frame to hold the replay pointer options
        #
        frame $w.point -bd 4 -relief ridge
        pack $w.point -side top -fill x
        label $w.point.info -text "Pointing to widgets"
        pack $w.point.info -side top -fill x
        checkbutton $w.point.arrow -anchor w \
            -text "Point red arrow window at widgets as they are replayed" \
            -variable ReplayData(pointWithArrow)
        if $ReplayData(pointWithArrow) {
            $w.point.arrow select
        }
        pack $w.point.arrow -side top -fill x
        checkbutton $w.point.pointer -anchor w \
            -text "Move mouse pointer to widgets are they are replayed" \
            -variable ReplayData(movePointer)
        if $ReplayData(movePointer) {
            $w.point.pointer select
        }
        pack $w.point.pointer -side top -fill x
        #
        # make a frame to hold the mouse speed options
        #
        frame $w.mspeed -bd 4 -relief ridge
        pack $w.mspeed -side top -fill x
        label $w.mspeed.info -text "Mouse speed"
        pack $w.mspeed.info -side top -fill x
        radiobutton $w.mspeed.ms1 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Slow" -value 1
        pack $w.mspeed.ms1 -side top -fill x
        radiobutton $w.mspeed.ms3 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Medium" -value 3
        pack $w.mspeed.ms3 -side top -fill x
        radiobutton $w.mspeed.ms6 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Fast" -value 6
        pack $w.mspeed.ms6 -side top -fill x
        radiobutton $w.mspeed.ms100 -anchor w -variable ReplayData(MouseSpeed) \
            -text "Very fast" -value 100
        pack $w.mspeed.ms100 -side top -fill x
        radiobutton $w.mspeed.msinf -anchor w  \
            -variable ReplayData(MouseSpeed) \
            -text "Warp (infinite)" -value 999
        pack $w.mspeed.msinf -side top -fill x
        $w.mspeed.ms3 invoke
        #
        # make a frame to hold the event replay options
        #
        frame $w.events -bd 4 -relief ridge
        pack $w.events -side top -fill x
        label $w.events.info -text "Events to skip"
        pack $w.events.info -side top -fill x
        checkbutton $w.events.enters -anchor w \
            -text "Move mouse pointer to enter and leave events" \
            -variable ReplayData(showEnterEvents)
        if $ReplayData(showEnterEvents) {
            $w.events.enters select
        }
        pack $w.events.enters -side top -fill x
        checkbutton $w.events.focuses -anchor w \
            -text "Move mouse pointer to focus events" \
            -variable ReplayData(showFocusEvents)
        if $ReplayData(showFocusEvents) {
            $w.events.focuses select
        }
        pack $w.events.focuses -side top -fill x
        #
        # make a frame to hold the display event options
        #
        frame $w.evdisp -bd 4 -relief ridge
        pack $w.evdisp -side top -fill x
        label $w.evdisp.info -text "Showing events"
        pack $w.evdisp.info -side top -fill x
        checkbutton $w.evdisp.onrecord -anchor w \
            -text "Show events as they are being recorded" \
            -variable ReplayData(showEventsRecording) \
            -command ShowEventLists
        if $ReplayData(showEventsRecording) {
            $w.evdisp.onrecord select
        }
        pack $w.evdisp.onrecord -side top -fill x
        checkbutton $w.evdisp.onreplay -anchor w \
            -text "Show events as they are being replayed" \
            -variable ReplayData(showEventsPlaying) \
            -command ShowEventLists
        if $ReplayData(showEventsPlaying) {
            $w.evdisp.onreplay select
        }
        pack $w.evdisp.onreplay -side top -fill x
        #
        # make the dismiss button.  Keep the window around so it will
        # come up faster next time.
        #
        button $w.dismiss -text "Dismiss" -command "wm withdraw $w"
        pack $w.dismiss  -side top
    }
}
#
# ShowEventLists: decide whether to show the event lists.
#
proc ShowEventLists {} {
    global ReplayData
    if {!$ReplayData(showEventsRecording) && !$ReplayData(showEventsPlaying)} {
        pack forget .replay.events
    } else {
        pack .replay.events -side top -fill both -epxand yes
    }
}
