#!/usr/local/bin/wish
proc tkerror {msg} {global errorInfo;puts "ERROR: $msg ==> $errorInfo"}
#
# buttons
#
button .button -text Button -command {puts "Button was pushed"}
pack .button -side top -fill x
checkbutton .cbutton -text CheckButton -bd 2 -relief raised \
    -command {puts "Check button was pushed"}
pack .cbutton -side top -fill x
radiobutton .r1button -text "RadioButton 1" -bd 2 -relief raised \
    -command {puts "Radio button 1 was pushed"} -value 1
pack .r1button -side top -fill x
radiobutton .r2button -text "RadioButton 2" -bd 2 -relief raised \
    -command {puts "Radio button 2 was pushed"} -value 2
pack .r2button -side top -fill x
#
# entry
#
entry .entry -relief sunken
pack .entry -side top -fill x
#
# scale
#
scale .scale -orient horizontal
pack .scale -side top -fill x
#
# listbox
#
frame .lb
pack .lb -side top -fill both -expand yes
scrollbar .lb.yscroll -orient vertical -command ".lb.listbox yview"
listbox .lb.listbox -width 10 -height 4 -bd 2 -relief raised \
    -yscroll ".lb.yscroll set"    
pack .lb.yscroll -side left -fill y
.lb.listbox insert 0 111 222 333 444 555 666 777 888 999
pack .lb.listbox -side right -fill both -expand yes
#
# text
#
text .text -width 10 -height 4 -bd 2 -relief raised
.text insert end {abcdef
ghijkl
mnopqr
stuvwx}
pack .text -side top -fill both -expand yes
.text tag add atag 1.1 1.4
.text tag configure atag -foreground green
.text tag bind atag <1> {.text tag configure atag -foreground purple}
.text tag bind atag <2> {.text tag configure atag -foreground green}
.text tag add btag 2.0 3.0
.text tag configure btag -foreground blue
.text tag bind btag <Enter> {.text tag configure btag -foreground red}
.text tag bind btag <Leave> {.text tag configure btag -foreground blue}
#
# canvas
#
canvas .canvas -width 180 -height 100 -bd 2 -relief raised
set r1 [.canvas create rectangle 10 10 80 40 -fill green]
set r2 [.canvas create rectangle 120 10 160 40 -fill green]
.canvas addtag rect all
.canvas bind rect <Enter> {.canvas itemconfigure current -fill yellow}
.canvas bind rect <Leave> {.canvas itemconfigure current -fill green}
set o1 [.canvas create oval 80 50 120 75 -fill blue]
.canvas bind $o1 <1> {.canvas itemconfigure current -fill red}
.canvas bind $o1 <2> {.canvas itemconfigure current -fill blue}
pack .canvas -side top -fill x
#
# quit
#
button .title -text "EXIT" -command exit
pack .title -side top
