#ifndef BLOB_INTERNAL_H
#define BLOB_INTERNAL_H

/*
 * blobInt.h --
 *
 *	Declarations of things used internally by the BLOB extension.
 *
 * Copyright (c) 1995 Andreas Kupries (aku@kisters.de)
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL I BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL,
 * INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS
 * SOFTWARE AND ITS DOCUMENTATION, EVEN IF I HAVE BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * I SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
 * I HAVE NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 * ENHANCEMENTS, OR MODIFICATIONS.
 *
 * CVS: $Id: blobInt.h,v 1.5 1996/01/13 21:44:53 aku Exp $
 */

#include "blob.h"

#ifndef TRUE
#define TRUE  (1)
#define FALSE (0)
#endif


EXTERN int
BlobObjectCmd _ANSI_ARGS_ ((ClientData  clientData,
			    Tcl_Interp* interp,
			    int         argc,
			    char**      argv));
/*
 * An object of the following structure is associated with all
 * blob object commands.  This is necessary to have access
 * to the extensions interpreter-asssociated hash-table during
 * command deletion.  It would have been possible to store
 * this information inside the blob too.  This was rejected
 * in favor of a clean separation of Tcl and C level functionality.
 */

typedef struct BlobClientData
{
  Blob           b;
  Tcl_HashTable* blobSet;
} BlobClientData;


/*
 * An instance of the structure following this comment is
 * associated with every interpreter used as argument to a call
 * of procedure 'Blob_Init ()'.
 */

typedef struct BlobInterpData {

  Tcl_HashTable blobSet;	/* Dictionary containing the handles
				 * of all blob objects created in
				 * the interpreter as keys.  The
				 * commands associated to the blob
				 * objects are stored as the hash-values.
				 */
  Tcl_HashTable convSet;	/* Registry of conversion procedures.
				 * The option strings are used as keys.
				 * Hashvalues are BlobConv structures. */
} BlobInterpData;



/*
 * An instance of the structure following this comment is
 * associated with conversion method registered via 'Blob_AddConversion'.
 */

typedef struct BlobConv {
  Blob_CvtString2Bin s2bFun; /* procedure to use for conversion of a
			      * string into binary data */
  Blob_CvtBin2String b2sFun; /* procedure to use for conversion of
			      * binary data into a string */
} BlobConv;



EXTERN int
BlobFindConversion _ANSI_ARGS_ ((Tcl_Interp*         interp,
				 CONST char*         code,
				 Blob_CvtString2Bin* s2bFun,
				 Blob_CvtBin2String* b2sFun));
/* available standard 'code's: 'no', 'esc', 'hex' */

EXTERN int
BlobAddStdConversionMethods _ANSI_ARGS_ ((Tcl_Interp* interp));


/*
 * Input processing
 * Retrieve binary data from command arguments (packing)
 */

EXTERN int
BlobGetFromPack _ANSI_ARGS_ ((Tcl_Interp* interp,
			      int         argc,
			      char**      argv,
			      int*        length,
			      char**      data,
			      int*        dataIsAllocated,
			      int*        skipped));

EXTERN int
BlobUnpack _ANSI_ARGS_ ((Tcl_Interp* interp,
			 Blob        b,
			 CONST char* arg,
			 char**      data));

/*
 * miscancellous utilities
 */

EXTERN int
BlobGetIntervalSpec _ANSI_ARGS_ ((Tcl_Interp* interp,
				  int         argc,
				  char**      argv,
				  int         limit,
				  int*        from,
				  int*        to));

EXTERN int
BlobGetIntervalSpecInside _ANSI_ARGS_ ((Tcl_Interp* interp,
					int         argc,
					char**      argv,
					int         limit,
					int*        from,
					int*        to,
					int*        numEdges));

/*
 * Remarks:
 *
 * This extension associates its own data structures with
 * any interpreter initializing it.  This is done via
 * 'Tcl_SetAssocData' and surrounding procedures.  The key
 * used here is "Blob".
 *
 * The associated information is a BlobInterpData structure
 * (See blobInt.h for more explanation).
 */

#define ASSOC_KEY "Blob"

#endif /* BLOB_INTERNAL_H */
