/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "CppTcl.h"
 *								   created:		1/18/95	{6:13:56 pm}
 *								   last	update:	24/7/96 {12:19:49 pm}
 *	 Author:  Vince	Darley 
 *	 E-mail:  vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	    www:  <http://www.fas.harvard.edu/~darley/>
 * ###################################################################
 */

#ifndef _EvoX_CppTcl_
#define _EvoX_CppTcl_

// Forward class declarations
class tcl_stream;
struct Tcl_Interp;
class tcl_args;

//@Section: CppTcl library
//@Man: The CppTcl API
//@{
/// The Cpptcl C init procedure for Tcl loading
extern "C" int Cpptcl_Init(Tcl_Interp*);
/// The C++ equivalent to 'Tcl_PkgInitProc' which will be used by your pkgs.
typedef int Cpptcl_PackageInitProc(tcl_stream&);
/// The Cpptcl C++ init procedure
extern Cpptcl_PackageInitProc Cpptcl_Init;
/// A utility procedure for use in your C init procedure
/** 
 * Use this	as follows:
 *	   extern "C" int Mypkg_Init(Tcl_Interp*);
 * 
 *	   int Mypkg_Init(Tcl_Interp* interp) {	
 *		   return Cpptcl_PkgInit(interp, Mypkg_Cppinit);
 *	   }
 *	   
 *	   Cpptcl_PackageInitProc Mypkg_Cppinit;
 *	   int Mypkg_Cppinit(tcl_stream& interp) {
 *		   ...
 *	   }
 */	
extern int Cpptcl_PkgInit(Tcl_Interp* interp, Cpptcl_PackageInitProc cpx_iproc);
/// Wrap an interpreter into a tcl_stream.  
/** 
 * Your	code will normally always use 'Cpptcl_PkgInit' and thereafter
 * use tcl_streams only.  So you won't normally	need this function call.
 */
extern tcl_stream& cpptcl_create_stream(Tcl_Interp*);
/// Typedef for object creation function
/** 
 * Your	'make_new' function	is of this form.  Every	non-abstract C++
 * object which	is to be interfaced	with Tcl should	have a static method:
 *	   static tcl_object* make_new(tcl_args& arg) {	
 *		   return new my_object(arg);
 *	   }
 * Note	that if	you	wish to	use	the	macros below, you must actually
 * call	this method	'make_new'.
 */
typedef class tcl_object* (*new_object_fn) (tcl_args&);
/// Version
#define CPPTCL_VERSION "1.1"
/// Simplifies object declaration (can't use with multiple inheritance)
/** 
 * Declare an abstract object using	this macro.	 It	relies upon	objects
 * obeying the Cpptcl RTTI system of using a static	'_type'	field.
 * If you need multiple-inheritance, you will have to call the metaobject
 * directly.  See 'cpptcl_metaobject' for details.
 */
#define Cpptcl_Abstract(obj,parent) \
	if(declare_abstract_cpx_object(interp,obj ::_type,parent ::_type, 1) == TCL_ERROR) \
		return TCL_ERROR; 

/// Simplifies object declaration (can't use with multiple inheritance)
/** 
 * Declare anobject	using this macro.  It relies upon objects
 * obeying the Cpptcl RTTI system of using a static	'_type'	field.
 * If you need multiple-inheritance, you will have to call the metaobject
 * directly.  See 'cpptcl_metaobject' for details.	Also if	you	wish
 * to have the object's	Tcl	creation command be	different from its '_type'
 * then	you	must call directly.
 */
#define Cpptcl_Object(obj,parent) \
	if(declare_cpx_object(interp, 0, obj ::make_new, obj ::_type, parent ::_type, 0,1) == TCL_ERROR) \
		return TCL_ERROR; 
/// The global metaobject.  You may occasionally want to access it directly.
extern class cpptcl_metaobject* _global_cpptcl_metaobject;
//@}


//@Section: CppTcl library
//@Man: CppTcl RTTI 
//@{
// Perhaps I should simplify these.

/// Is type 'a' descended from type 'b'?
/** 
 * Is type 'a' descended from type 'b'?
 * 'a' is a	character string
 * 'b' is the name of a	C++	class
 * The return value	is a bool
 */
#define maycast(a,b) _global_cpptcl_metaobject->is_of_type(a,b::_type)
/// Now 'b' is also a character string.
/** 
 * Now 'b' is also a character string.
 */
#define namecast(a,b) _global_cpptcl_metaobject->is_of_type(a,b)
/// Is object 'a' descended from a type 'b'.
/** 
 * Is object 'a' descended from	a type 'b'.
 * 'a' is a	pointer	to an actual object	in existence
 * 'b' is the name of a	C++	class
 * The return value	is either a	cast object	or zero	if the cast	failed.
 * The user	should check the return	value before using.
 */
#define ckcast(a,b) (namecast(a->type(),b::_type) ? (b*)a : (b*) 0)

/// Do a cast.
/** 
 * Do a	cast.
 * As with ckcast, except this is used where we	expect a cast to work, and wish
 * to dump if it fails.	i.e. we're not going to	check if it	worked.	If debugging
 * is off, then	this just does an ordinary cast.
 */
#ifndef SLOW_DEBUG
/// this is the default
#define cast(a,b) ((b*)a)
#else
/// this is a _lot_ slower but checks type dynamically
#define cast(a,b) (namecast(a->type(),b::_type) ? (b*)a : (b*) 0)
#endif

//------------------------------------------------------------------
// Everything below is for debugging and/or compilation
//------------------------------------------------------------------


// various hacks for compilation under different compilers

#ifdef __SC__ // Symantec C++ 8.03 --- currently unsupported
	#define BAD_COMPILER
	#define mutable 
	#define INT (int)
#endif

#ifdef __MWERKS__  // MetroWerks CodeWarrior 9
	#include "MW_EvoXHeader.h"
	#define mutable
	#define INT (int)
	#include <assert.h>
	#define NO_EXCEPTION_HANDLING
	#define NO_ANSI_BOOL
#endif

#ifdef __GNUC__ // GCC 2.7.2
	#define INT
	#include <assert.h>
	#define NO_EXCEPTION_HANDLING
	#ifndef STATIC_LINKING_ONLY
	// if we may be linking dynamically, we need this flag
	#define NO_STATIC_INITIALISERS
	#endif
#endif

// Compilers that don't have ANSI 'bool' as a real type
// have to make a few casts here and there.
#ifdef NO_ANSI_BOOL
	#define BOOL (int)
	typedef enum  { false = 0, true =1 } bool;
	class istream;
	class ostream;
	istream& operator >> (istream& i, bool& b);
	ostream& operator << (ostream& i, bool b);
#else
	#define BOOL
#endif

#define DO_NOTHING ;

#ifdef DEBUG_PRINT
	#define PRINT(var); cout << #var << " = " << var << endl;
#else
	#define PRINT(var);
#endif



#endif
