/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpptcl_control.h"
 *									  created: 26/6/96 {12:11:41 pm} 
 *								  last update: 6/7/96 {10:20:07 am} 
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: Control and utility object for Cpptcl
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	26/6/96	 VMD 1.0 original
 * ###################################################################
 */

#ifndef _EvoX_cpptcl_control_
#define _EvoX_cpptcl_control_

#include "tcl_object.h"

//@Section: CppTcl library
///
/**
 * -------------------------------------------------------------------------
 *	 
 * "class cpptcl_control" --
 *	
 *	Implements the 'cpptcl'	object which supports command completion
 *	in the Cpptcl object system.  Usage	is as follows:
 *	   
 *	   % cpptcl	complete object	co
 *	   Completions:
 *	   object command
 *	   object compost
 *	   
 *	which will return all sub commands of 'object' which begin with	'co'.
 *	To find	the	maximum	common completion, use:
 *	   % cpptcl	maxCompletion
 *	and	to get back	the	original command, use:
 *	   % cpptcl	origCommand
 *	For	the	above example these	would return 'm' and 'object co' 
 *	respectively)
 *		   
 *	Ideally this should be used transparently in the tcl shell, by	   
 *	binding, say 'Tab', to grab the current line, prefix it with 	   
 *	'cpptcl complete ', evaluate it and then generate the completion.
 *
 *  You can also use 'cpptcl isCpptcl cmd' to check if an tcl command
 *  really is a Cpptcl object.
 *
 * Command Summary:
 *
 *		% documentObject cpptcl
 *		cpptcl author : name and e-mail address for bug reports
 *		cpptcl complete : complete a command on a Cpptcl object
 *		cpptcl isCpptcl : is this a Cpptcl object
 *		cpptcl maxCompletion : return maximum length common prefix for last completion
 *		cpptcl origCommand : return length of command which was completed
 *		cpptcl rename : changes the Tcl command name of the object
 *		cpptcl webPage : web page for online documentation
 *		   
 * Side	effects:
 *	Issues fake	commands to	the	object being queried, so such objects must
 *	be interfaced correctly	to the Cpptcl system, or commands may actually
 *	be carried out.	 Make sure you use 'arg	>> done' correctly to avoid
 *	any	problems (and the 'NO_EXCEPTIONS' macro if required).
 *	
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class cpptcl_control: public tcl_object {
  public:
	/// Construct the 'cpptcl' completion object
    /* This is called automatically by the package init procedure */
	cpptcl_control(tcl_stream& i, const char* name)
        :tcl_object(i,name), max_completion(0), orig_command(0) {}
                
	/// Free any allocated memory and delete the object
	~cpptcl_control(void) { free_completion_mem();}
	
	/// Free my memory
	void free_completion_mem(void);	
	/// Implement the 'complete', 'origCommand' and other commands.
	int parse_tcl_command(tcl_args& arg);
	
  protected:
	/// Stores the max completion
  	char* max_completion;
	/// Stores the original command
	char* orig_command;
	
};

#endif
