/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "object.h"
 *									  created: 19/12/95	{1:41:45 am} 
 *								  last update: 24/7/96 {12:44:40 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	19/12/95 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_object_
#define _EvoX_object_

#include "list.h"
#include "CppTcl.h"

struct cpx_constructor_info;
/// Typedef for 'make_new' functions for cpptclextra objects
typedef class tcl_object* (*cpx_object_fn) (cpx_constructor_info*);

//@Section: CppTclExtra library
///
class object: public list<object*>{ 
  public:
	///
	const char* tcl_command;
	///
	bool is_cpx_object;
	
	///
	union ff {
		cpx_object_fn cpx;
		new_object_fn obj;
	} f;
	
	///
	const char* type;
	
	///
  	list<object*> parent_list;

	///
	object(const char* type);
	///
	object(const char* tcl_command, cpx_object_fn func, const char* type);
	///
	object(const char* tcl_command, new_object_fn func, const char* type);
	///
	~object(void) {}
};


#endif

