/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "cpptcl_init.cc"
 *									  created: 18/12/95	{9:12:43 pm} 
 *								  last update: 24/7/96 {3:40:48 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "CppTcl.h"
#include "cpptcl_init.h"
#include "cpptcl_control.h"
#include <assert.h>
#include "cpptcl_metaobject.h"

static cpptcl_control* cpptcl_controller=0;
cpptcl_metaobject* _global_cpptcl_metaobject = 0;


extern "C" int Cpptcl_Init(Tcl_Interp* interp) {
	return Cpptcl_PkgInit(interp,Cpptcl_Init);
}

int Cpptcl_PkgInit(Tcl_Interp* interp, Cpptcl_PackageInitProc cpx_iproc) {
	tcl_stream& tcl_ = cpptcl_create_stream(interp);
	if((*cpx_iproc)(tcl_) == TCL_ERROR) {
		return TCL_ERROR;
	}
	return TCL_OK;
}

int Cpptcl_Init(tcl_stream& tcl_) {
	if(!cpptcl_controller)
		cpptcl_controller = new cpptcl_control(tcl_,"cpptcl");
	if(!_global_cpptcl_metaobject)
		update_metaobject(tcl_);

	Tcl_PkgProvide(tcl_,"Cpptcl",CPPTCL_VERSION);
	#ifndef NO_ITCL
	return tcl_.PackageLibraryInit("cpptcl_library","CPPTCL_LIBRARY","cpptcl",
	                               "cpptcl.tcl","1.1","CppTcl");
	#else
	/* You'll have to find the library files some other way ;-) */
	return TCL_OK;
	#endif
}

void update_metaobject(tcl_stream& i, cpptcl_metaobject_fn f) {
	static char cpxControl[] = "cpptclControl";
	tcl_args t(i);
	t.setName(cpxControl);
	if(_global_cpptcl_metaobject ==0) {
		if(f) {
			_global_cpptcl_metaobject = (*f)(t,0);
		} else {
			_global_cpptcl_metaobject = new cpptcl_metaobject(t);
		}
	} else {
		/* This does all that's needed */
		_global_cpptcl_metaobject = (*f)(t,_global_cpptcl_metaobject);
	}
	
}
	

typedef struct tcl_stream_link  {
	tcl_stream* stream;
	tcl_stream_link* next;
	short refs;
	tcl_stream_link(tcl_stream* s){ stream = s; next = 0; refs=0;}
	~tcl_stream_link(void) {}
	const tcl_stream_link& operator= (tcl_stream_link& t) {
		stream = t.stream;
		next = t.next;
		refs = t.refs;
		return *this;
	}
	
} tcl_stream_link;

tcl_stream* cpptcl_stream_memory(Tcl_Interp* interp, bool add_not_delete);
void cpptcl_delete_stream(tcl_stream& i);

/** 
 * -------------------------------------------------------------------------
 *	 
 * "cpptcl_create_stream" --
 *  
 *  Wraps a tcl interpreter (type Tcl_Interp) inside a tcl_stream.  Checks to 
 *  see if there already exists a stream with that interpreter, and if so 
 *  returns the already-created tcl_stream.  This is done because confusion 
 *  could arise if two tcl_streams manipulated the same interpreter (probably 
 *  hard to do with the current setup, but easy in a multi-threaded scenario).
 *         
 * Results:
 *  Returns a valid tcl_stream which wraps the given Tcl_Interp
 *  
 * Side effects:
 *  May create a new tcl_stream, and may add to its static list of known
 *  interpreter/stream pairs.
 * -------------------------------------------------------------------------
 */
tcl_stream& cpptcl_create_stream(Tcl_Interp* interp) {
	return *(cpptcl_stream_memory(interp,true));
}

void cpptcl_delete_stream(tcl_stream& i) {
	(void) cpptcl_stream_memory(i.interpreter(),false);
}

tcl_stream* cpptcl_stream_memory(Tcl_Interp* interp, bool add_not_delete) {
	static tcl_stream_link all_tcl_streams = tcl_stream_link(0);
	tcl_stream_link *i;
	tcl_stream_link *j=0;
	for (i = &all_tcl_streams; i->stream !=0; i = i->next) {
		if(i->stream->interpreter() == interp) {
			j = i;
			break;
		}
	}
	if(add_not_delete) {
		// we're creating a stream
		if(j) {
			j->refs++;
		} else {
			// 'i' is at the end of the list
			j = i;
			j->stream = new tcl_stream(interp);
			j->next = new tcl_stream_link(0);
		}
		return j->stream;
	} else {
		// we delete an old stream
		assert(j!=0);
		if(j->refs) {
			j->refs--;
			return 0;
			
		} else {
			// delete the interp too
			if(j == &all_tcl_streams) {
				all_tcl_streams = *(all_tcl_streams.next);
				delete j;
				return 0;
			} else {
				for (i = &all_tcl_streams; i->stream !=0; i = i->next) {
					if(i->next == j) {
						i->next = j->next;
						delete j;
						return 0;
					}
				}
				// error
				assert(0==1);
				return 0;
			}
		}
	}
			
}

