/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "tcl_args_ts.cc"
 *									  created: 29/4/96 {4:54:30	pm}	
 *								  last update: 29/4/96 {6:38:59 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	Template Specialisations:   See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_args.h"

// to be replaced by RTTI eventually.
const char* GETTYPE(short&);
const char* GETTYPE(bool&);
const char* GETTYPE(long&);
const char* GETTYPE(float&);
const char* GETTYPE(double&);
const char* GETTYPE(char&);

const char* GETTYPE(short&) {return "short";}
const char* GETTYPE(bool&) {return "bool";}
const char* GETTYPE(long&) {return "long";}
const char* GETTYPE(float&) {return "float";}
const char* GETTYPE(double&) {return "double";}
const char* GETTYPE(char&) {return "char";}

tcl_args& operator >> (tcl_args& arg, bool& v){
	arg.set_conversion_type("bool");
	const char* buf = 0;
	arg.const_string_read(buf);

	if(buf){
		int readbool;
		int res = Tcl_GetBoolean(arg.interpreter(),(char*) buf, &readbool);
		if(res == TCL_ERROR) {
			arg.signal_error(tcl_args::Conversion);
		}
		v = (readbool ? true : false);
	}
	arg.read_done();
	return arg;
}

tcl_args& operator >> (tcl_args& arg, char*& v){
	arg.set_conversion_type("char*");
	if(arg.is_optional_arg() && !arg.args_left()) {
		v = 0;
		arg.pretend_read_from_me();
	} else {
		arg.check_read() >> v;
		arg.check_after();
		arg.parsed_so_far << v << " ";
	}	
	arg.read_done();
	return arg;
}	

tcl_args& operator >> (tcl_args& arg ,const char*& v){
	arg.set_conversion_type("const char*");
	arg.const_string_read(v);
	if(v){
		arg.parsed_so_far << v << " ";
	}	
	arg.read_done();
	return arg;
}	

