/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "tcl_class.cc"
 *								   created:		1/22/95	{11:33:30 pm}
 *								   last	update:	24/7/96 {11:50:59 am}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */

#include "tcl_class.h"
#include <strstream.h>
#include <string.h>

int tcl_class::parse_tcl_command(tcl_args& arg){
	// did they supply a name for the new object?
    if (arg.empty()) {
		tcl_ << tcl_command << ": No name or other arguments supplied." 
		     << tcl_error;
		return tcl_;
	}
    // In case the user wishes to rename, we do that now:
	// This has the side-effect of disallowing any object
	// called "rename".
	if (!strcmp(arg.peek(),"rename")){
		return tcl_object::parse_tcl_command(arg);
	}
	
	// yes, so call the make function	
	if (tcl_object* o = (*newFunc)(arg)){
		if(!arg) {
			//#ifndef TCL_DONT_CHECK_CONSTRUCTOR_ARGS
			arg >> done;
			if(arg.haveErr) {
				delete o;
				return TCL_ERROR;
			}
			//#endif
		} else {
			if(!arg.empty())
				if(o->parse_configuration_values(arg) == TCL_ERROR)
					return TCL_ERROR;
		}
		tcl_ << o->get_tcl_command() << result;
		return tcl_;
	} else {
		// We expect the constructor to return whatever 
		// error message is appropriate, or signal an
		// exception if they're supported.
		return TCL_ERROR;
	}
    
}

