/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "cpx_class.h"
 *								   created:		1/23/95	{8:38:27 pm}
 *								   last	update:	20/5/96 {4:56:14 pm}
 *	Author:	  Vince	Darley 
 *	Internet: vince@das.harvard.edu
 *	US mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: A borrowed	class for tcl/C++ interfacing
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/23/95	 VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_cpx_class_
#define _EvoX_cpx_class_

/* This file defines the interface to tcl_class, a derived class of tcl_object.  A
   tcl_class is a tcl_object used to create other tcl_objects.  In other words, we
   might create a tcl_class bound to the tcl command "card" which creates new
   tcl_object's bound to commands like "QueenOfHearts".  Thus, a tcl_class has
   only one response to being invoked from tcl: the creation of a new tcl_object.

   It works by storing a pointer to a static member function of the tcl_object to
   be created.  When the tcl_class procedure is invoked, it passes on its
   arguments to this "make function" of the tcl_object, and this function should
   then create a new instance of the tcl_object.

   tcl_class must be instantiated from C++.  The associated tcl_object's can then
   be instantiated from tcl via the tcl_class.
*/

#include "CppTclHeaders.h"
#include "CppTclExtra.h"

//@Section: CppTclExtra library
///
class cpx_class : public tcl_object {
  public:

	// we need to know our interpreter, the name of the tcl command to bind 
	// to, and a pointer to the make function to use.
	///

    cpx_class(tcl_stream& interp, const char* name, cpx_object_fn func) :
          tcl_object(interp, name), newFunc(func) {}

    // called when we are invoked; passes argc and argv on to the make function.
	///
    int parse_tcl_command(tcl_args& arg);

 protected:

	// store a pointer to the make function.
	///
	cpx_object_fn newFunc;
};

#endif /*cpx_class*/
