/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "info_file.h"
 *								   created:		1/30/95	{11:26:32 am}
 *								   last	update:	20/5/96 {4:55:05 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	1/30/95	  VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_file_
#define _EvoX_info_file_

#include "info_base.h"
#include <fstream.h>

//@Section: CppTclExtra library
///
class info_file : public info_base {
  public:
	///
    static const char* _type;
	///
    info_file(const char* tcl_name, cpx_with_info* container);
	///
    bool can_add(const char* t) const;
	///
    cpx_error add_info(info_base*);
	///
    cpx_error remove_info(info_base*);
	/// return true if file is ok
    virtual bool set_file(const char* name, bool append)=0;
	///
    virtual void close_file(void)=0;
	///
    bool ready(void) const ;
	///
    const char* file_name(void) const;
    ///
    virtual void reset_to_start(void)=0;
    /// 
    bool have_file(void) const { return (_file_name!=0 ? true : false);}
  protected:
    /// returns the name of my file
	ostream& write_to_stream(ostream& o);
	/// sets the name of my file, and opens the file (in over-write mode if output)
	istream& read_from_stream(istream& i);
	///
    s_info_base* new_static(const char* n);
	///
    int parse_tcl_command(tcl_args& arg);
    
	///
    char* _file_name;
};

//@Section: CppTclExtra library
///
class s_info_file: public s_info_base  {
  public:
	///
	s_info_file(const char* name)
		:s_info_base(name) {};
		
};

#endif
