/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_limit.h"
 *									  created: 5/11/95 {2:20:45	pm}	
 *								  last update: 20/5/96 {4:54:52 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	5/11/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_limit_
#define _EvoX_info_limit_

class cpx_with_info;

//@Section: CppTclExtra library
///
template <class T>
class limit_ {
  public:
	///
    limit_(const char* i=0):_items(i){}
	///
    virtual ~limit_(void) {}
	///
    virtual T value(const cpx_with_info* read_from) const=0;
	///
    bool itemised(void) const { return (_items ? true : false );}
	///
    const char* items(void) const {return _items;}
  private:
	///
    const char* _items;
};

//@Section: CppTclExtra library
///
template <class T>
class limit_fixed: public limit_<T> {
  public:	
	///
    limit_fixed(T t, const char* i=0):limit_<T>(i),_t(t){}
   ~limit_fixed(void) {}
	///
    T value(const cpx_with_info* /* read_from */) const {return _t;}
  private:
	///
    T _t;
};

//@Section: CppTclExtra library
///
template <class T>
class limit_var: public limit_<T> {
  public:
	///
    const bool itemised;
	///
    limit_var(const char* _n);
   ~limit_var(void) {}
	///
    T value(const cpx_with_info* read_from) const;
  private:
	///
    const char* _name;
};

#endif
