/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_observable.h"
 *									  created: 7/31/95 {12:55:01 AM} 
 *								  last update: 20/5/96 {4:54:49 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	7/31/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_observable_
#define _EvoX_info_observable_

#include "info_base.h"

//@Section: CppTclExtra library
///

class s_info_source : public s_info_base {
  public:
	///
    s_info_source(const char* n):s_info_base(n) {}
	///
    ~s_info_source(void) {}
	///
    quick_ref pointer_to_me;
};

//@Section: CppTclExtra library
///
class info_observable : public info_base {
  private:
	///
    short quick_lookup;
  public:
	///
    static const char* _type;
	///
    info_observable(const char* tcl_name, class cpx_with_info* container);
	///
    bool can_add(const char* t) const;
	///
    cpx_error add_info(info_base*);
	///
    cpx_error remove_info(info_base*);
	///
	virtual void make_info_gatherer(class cpx_with_info*)=0;
	///
    void set_quick_index(short);
	///
    short get_quick_index(void) const { return quick_lookup;}
    
	///
    quick_ref my_quick_ref(void);
    ///
    virtual void conversion_error(tcl_args&)=0;
  protected:
};

#endif
