/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_pretender.h"
 *									  created: 5/11/95 {2:14:43	pm}	
 *								  last update: 20/5/96 {4:54:44 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 * *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	5/11/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_pretender_
#define _EvoX_info_pretender_

template <class T> class info_pretender;
template <class T> class info_source_t;
//template <class T> class info_source_var;
class info_source_bool;

//@Section: CppTclExtra library
///

class info_castable {
  public:
	///
	virtual	operator const info_pretender<short>& () const=0;
	///
	virtual	void limits(short, short) const=0;
	///
	virtual	operator const info_pretender<long>& () const=0;
	///
	virtual	void limits(long, long) const=0;
	///
	virtual	operator const info_pretender<bool>& () const=0;
	///
	virtual	void limits(bool, bool) const=0;
	///
	virtual	operator const info_pretender<float>& () const=0;
	///
	virtual	void limits(float, float) const=0;
	///
	virtual	operator const info_pretender<double>& () const=0;
	///
	virtual	void limits(double, double) const=0;
	///
	virtual	operator const info_pretender<char>& () const=0;
	///
	virtual	void limits(char, char) const=0;
	///
	virtual ~info_castable(void) {}
};

//@Section: CppTclExtra library
///
template <class T>
class info_pretender: virtual public info_castable  {
	///
	friend class info_source_t<T>;
	//friend class info_source_var<T>;
	///
	friend class info_source_bool;
  protected:
	//T p_t;
	///
	info_pretender(void) {}
  public:
	///
	virtual operator T () const=0;
	
	// it's not clear to me that these should be necessary
	// but mwerks gives me an ambiguous overloaded fn error.
	///
	#ifdef __MWERKS__
	///
	operator - (T tt) const  {return operator T() - tt;}
	///
	operator + (T tt) const  {return operator T() + tt;}
	///
	operator / (T tt) const  {return operator T() / tt;}
	///
	operator * (T tt) const  {return operator T() * tt;}
	///
	operator ! () const  { return !(operator T());}
	///
	operator == (T tt) const  { return (operator T() == tt);}
	///
	operator > (T tt) const  { return (operator T() > tt);}
	///
	operator >= (T tt) const  { return (operator T() >= tt);}
	///
	operator < (T tt) const  { return (operator T() < tt);}
	///
	operator <= (T tt) const  { return (operator T() <= tt);}
	///
	operator != (T tt) const  { return (operator T() != tt);}
	///
	operator && (T tt) const  { return (operator T() && tt);}
	///
	operator || (T tt) const  { return (operator T() || tt);}	
	///
	#endif
	
	///
	virtual ~info_pretender(void) {}
	
	//info_pretender(T){}//:p_t(tt) {}
	///
	info_pretender(const info_pretender<T>&){}//:p_t(i.p_t) {}

	/* gcc 2.7 complains about some of these never being used */
	/* (it's correct but annoying) */
	///
	inline operator const info_pretender<short>& () const;
	///
	void limits(short, short) const { }
	///
	inline operator const info_pretender<long>& () const;
	///
	void limits(long, long) const { }
	///
	inline operator const info_pretender<bool>& () const;
	///
	void limits(bool, bool) const { }
	///
	inline operator const info_pretender<char>& () const;
	///
	void limits(char, char) const { }
	///
	inline operator const info_pretender<float>& () const;
	///
	void limits(float, float) const { }
	///
	inline operator const info_pretender<double>& () const ;
	///
	void limits(double, double) const { }
	
};

//@Section: CppTclExtra library
///
template <class T>
class info_basic: public info_pretender<T> {
  private:
	///
	T p_t;
  public:
	///
	inline operator T () const { return p_t;}
	///
	inline info_basic(T t):p_t(t){}
	///
  	~info_basic(void){}
	///
	info_basic(const info_basic<T>& i):p_t(i.p_t) {}
	
};

// without this typedef gcc 2.7.2 gives a ridiculous
// parse error on the first function below.  It copes
// ok with the rest. Weird!!!
typedef const info_pretender<long> ipl;

template <class T>
info_pretender<T>::operator ipl& () const {
	return info_basic<long>((long) (T) (*this));
}
template <class T>
info_pretender<T>::operator const info_pretender<short>& () const {
	return info_basic<short>((short) (T) (*this));
}
template <class T>
info_pretender<T>::operator const info_pretender<bool>& () const { 
	return info_basic<bool>((bool) (T) (*this));
}
template <class T>
info_pretender<T>::operator const info_pretender<char>& () const { 
	return info_basic<char>((char) (T) (*this));
}
template <class T>
info_pretender<T>::operator const info_pretender<float>& () const { 
	return info_basic<float>((float) (T) (*this));
}
template <class T>
info_pretender<T>::operator const info_pretender<double>& () const { 
	return info_basic<double>((double) (T) (*this));
}

#endif
