/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems
 * 
 *	FILE: "info_source_var.h"
 *									  created: 7/26/95 {9:38:12	PM}	
 *								  last update: 20/5/96 {4:53:38 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<mailto:vince@das.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	7/26/95	VMD	1.0	original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_info_source_var_
#define _EvoX_info_source_var_

#include "info_source_t.h"

typedef void (cpx_with_info::*info_adjust_fn)(void);

//@Section: CppTclExtra library
///
template <class T>
class s_info_source_var: public s_info_source_<T> {
  public:
	///
    s_info_source_var(const char* n):s_info_source_<T>(n) {}
	///
	info_adjust_fn adjust_fn;
};

//@Section: CppTclExtra library
///
template <class T>
class info_source_v : public info_source_t<T> {
  protected:
	///
  	virtual T& my_val(void)=0;
  	
  public:
	///
    info_source_v(const char* tcl_name, cpx_with_info* container, 
					quick_ref ref);
	///
    inline operator T () const { return ((info_source_v<T>*)this)->my_val();}
	///
	inline T operator+= (T t) { return my_val() += t;}
	///
	inline T operator/= (T t) { return my_val() /= t;}
	///
	inline T operator*= (T t) { return my_val() *= t;}
	///
	inline T operator-= (T t) { return my_val() -= t;}
	/// prefix ++
    inline info_source_v<T>& operator++ () { my_val()++; return *this;}
	/// postfix ++
    inline T operator++ (int) { return my_val()++;}
	///
    inline T operator-- () { return my_val()--;}
	///
    inline const info_source_t<T>& operator= (const T& t)  { 
    	my_val() = t; return *this;
    }
	///
    bool ready(void) const;
    
  protected:
	///
    s_info_base* new_static(const char* n);
  // get internal compiler error on Solaris 5.5 with gcc2.7.2
  // if we don't have this destructor explicitly
#ifdef __GNUC__ 
    ~info_source_v(void){}
#endif  
};

//@Section: CppTclExtra library
///
template <class T>
class info_source_var : public info_source_v<T> {
  protected:
	///
    T var_t;  	
	///
    T& my_val(void){ return var_t;}
  public:
	///
    inline const info_source_t<T>& operator= (const T& t)  { 
    	return info_source_v<T>::operator= (t);
    }
	///
	inline const info_source_t<T>& operator= (const info_source_var<T>& i){
		return info_source_t<T>::operator= (i);
	}
	///
    info_source_var(const char* tcl_name, cpx_with_info* container, 
					quick_ref ref=0);
  
};

//@Section: CppTclExtra library
///
template <class T>
class info_source_var_ref : public info_source_v<T> {
  protected:
	///
    T& ref_t;  	
	///
  	T& my_val(void){ return ref_t;}
  public:
	///
    inline const info_source_t<T>& operator= (const T& t)  { 
    	return info_source_v<T>::operator= (t);
	///
    }
	///
	inline const info_source_t<T>& operator= (const info_source_var_ref<T>& i){
		return info_source_t<T>::operator= (i);
	///
	}
	///
    info_source_var_ref(const char* tcl_name, cpx_with_info* container, 
					T& my_ref, quick_ref ref=0);
  
};

#endif
