/* -*-C++-*-
 * ############################################################################
 *	EvoX - evolution in	complex	systems							  
 *	
 *	FILE: "record_keeper.h"
 *										   created:	12/14/93 10:26:52 AM
 *									   last	update:	26/6/96 {2:10:57 pm}
 *	  by: Vince	Darley
 *			 E-mail: vince@das.harvard.edu
 *			   mail:   Divison of Applied Sciences,	Harvard	University
 *					Cambridge MA 02138
 * 
 *	DESCRIPTION: Mediates flow of interesting information between
 *				 the user and the different	CppTclExtra objects 
 *				 
 *	HISTORY
 *					 
 *	modified who rev reason
 *	-------- --- --- ------	
 *	12/14/93 VMD 1.0 Original
 *	1/12/94	 VMD 1.1 Created internal hierarchy	of analysis-nodes as planned
 *	16/7/94	  VMD 1.2 Now allows for multiple inheritance
 *	_/_/_
 * ############################################################################
 */

#ifndef _EvoX_record_keeper_
#define _EvoX_record_keeper_

#include "cpx_base.h"
#include "CppTclExtra.h"
#include "cpx_with_info.h"
#include "info_source_var.h"
#include "info_file_o.h"

//@Section: CppTclExtra library
///
/** 
 * -------------------------------------------------------------------------
 *	 
 * "record_keeper"	--
 *	
 *	Important control object of	which a	single instance	'cpptclControl'
 *	exists in the Tcl interpreter.	It is created automatically	by the
 *	package	init procedure.
 *		   
 * Command Summary:
 *	   
 *	   % documentObject	cpptclControl
 *	
 * --Version--Author------------------Changes-------------------------------  
 *	  1.0	  <vince@das.harvard.edu> original
 * -------------------------------------------------------------------------
 */
class record_keeper: public cpx_with_info {
  public:
  	friend cpx_base;
  
  public:
	///
    record_keeper(tcl_args&);
   ~record_keeper(void);

  protected:	  
	///
    ostream& status(short) const;
	///
    ostream& error(short) const;
	///
    ostream& archive(archive_type=ARCHIVE) const;

	///
    mutable info_file_o archive_file;
	///
    info_source_var<short> error_level;
	///
    info_source_var<short> status_level;
    
  private:
	///
  	ostream& null(void) const;
};

extern record_keeper* _cpx_record_keeper;

#endif





