/* -*-C++-*-
 * ###################################################################
 *	EvoX - evolution in	complex	systems	 
 * 
 *	FILE: "template_utils.h"
 *								   created:		10/30/94 {6:10:26 pm}
 *								   last	update:	24/7/96 {12:30:04 pm}
 *	Author:	  Vince	Darley 
 *	 E-mail: vince@das.harvard.edu
 *	   mail:  Divison of Applied Sciences, Harvard University
 *			  Cambridge	MA 02138
 *	
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	10/30/94   VMD 1.0 original
 *	_/_/_
 * ###################################################################
 */

#ifndef _EvoX_template_utils_
#define _EvoX_template_utils_

template <class T>
void swap(T& a, T &b);
//@Section: CppTclExtra library
///
template <class T>
struct cpx_pair  {
	///
	T x;
	///
	T y;
	///
	cpx_pair(T xx, T yy):x(xx),y(yy) {}
	///
	cpx_pair(void) {}
   ~cpx_pair(void) {}
};

//@Section: CppTclExtra library
///
template <class T>
class ring  {
  private:
	///
	T* box;
	
  public:
	///
	const long size;
	///
	T& item (long index) {
		return box[index % size];
	}
	///
	ring(long sz):size(sz) {
		box = new T[size];
	}
	
	///
	~ring(void) {
		delete [] box;
	}
};
	
	
	
	
	
	
	
	
#endif
